package com.biz.crm.nebular.dms.order;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 订单导入vo
 * @Author: chenrong
 * @Date: 2021/3/23 10:51
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "OrderImportVo", description = "订单导入vo")
public class OrderImportVo extends AbstractImportVo implements Serializable {

  private static final long serialVersionUID = -8095888457051499443L;

  @ExcelProperty(value = "客户编码", index = 0)
  @ColumnWidth(20)
  private String cusCode;

  @ExcelProperty(value = "客户名称", index = 1)
  @ColumnWidth(20)
  private String cusName;

  @ExcelProperty(value = "订单类型编码")
  @ExcelIgnore
  private String orderTypeCode;

  @ExcelProperty(value = "订单类型名称", index = 2)
  @ColumnWidth(20)
  private String orderTypeName;

  @ExcelProperty(value = "收货方编码", index = 3)
  @ColumnWidth(20)
  private String pickAddressCode;

  @ExcelProperty(value = "商品编码", index = 4)
  @ColumnWidth(20)
  private String productCode;

  @ExcelProperty(value = "商品名称", index = 5)
  @ColumnWidth(20)
  private String productName;

  @ExcelProperty(value = "购买数量", index = 6)
  @ColumnWidth(20)
  private String count;

  @ExcelProperty(value = "收货日期", index = 7)
  @ColumnWidth(20)
  private String pickDate;

  @ExcelProperty(value = "备注", index = 8)
  @ColumnWidth(20)
  private String remark;

  @ExcelProperty(value = "价格")
  @ExcelIgnore
  private BigDecimal price;

  @ExcelProperty(value = "金额")
  @ExcelIgnore
  private BigDecimal amount;
}
