package com.biz.crm.nebular.dms.order;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: huojia
 * @DateTime: 2021/1/28 19:05
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "订单主数据vo")
public class OrderVo extends CrmExtVo {

    //------------------订单基本信息----------------------

    @ApiModelProperty(value = "订单来源 dms_order_source")
    private String fromType;

    @ApiModelProperty(value = "订单来源编号(额外标记)")
    private String sourceCode;

    @ApiModelProperty(value = "订单编号")
    private String orderCode;

    @ApiModelProperty(value = "订单类型(dms_order_type)")
    private String type;

    @ApiModelProperty(value = "订单状态(dms_order_state)")
    private String state;

    @ApiModelProperty(value = "是否是暂存订单(yesOrNo)")
    private String temporaryFlag;

    //--------------------订单商品相关信息------------------------

    @ApiModelProperty(value = "订单总重量(克)")
    private BigDecimal weightOfGram;

    @ApiModelProperty(value = "订单总重量(千克)")
    private BigDecimal weightOfKilogram;

    @ApiModelProperty(value = "订单总重量(吨)")
    private BigDecimal weightOfTon;

    @ApiModelProperty(value = "商品总数量")
    private BigDecimal productNum;

    //--------------------------订单金额---------------------------------

    @ApiModelProperty(value = "订单总金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "订单促销优惠金额")
    private BigDecimal promotionAmount;

    @ApiModelProperty(value = "订单折扣费用使用金额")
    private BigDecimal discountAmount;

    @ApiModelProperty(value = "订单折扣费用最大使用金额")
    private BigDecimal maxDiscountAmount;

    @ApiModelProperty(value = "订单货补费用使用金额")
    private BigDecimal repAmount;

    @ApiModelProperty(value = "实际支付金额")
    private BigDecimal actualAmount;


    //-------------------------交货信息---------------------------

    @ApiModelProperty(value = "提货方式(dms_order_pick_type)")
    private String pickType;

    @ApiModelProperty(value = "收货地址")
    private String pickAdress;

    @ApiModelProperty(value = "联系人姓名")
    private String contactsName;

    @ApiModelProperty(value = "联系人电话")
    private String contactsPhone;

    @ApiModelProperty(value = "交货日期(yyyy-MM-dd HH:mm:ss)")
    private String giveDate;


    //----------------------客户信息-------------------------
    @ApiModelProperty(value = "客户编码")
    private String cusCode;

    @ApiModelProperty(value = "客户名称")
    private String cusName;

    @ApiModelProperty(value = "客户sap编码")
    private String cusSapCode;

    @ApiModelProperty(value = "客户所属公司编码")
    private String companyCode ;

    @ApiModelProperty(value = "客户所属公司名称")
    private String companyName;

    @ApiModelProperty(value = "客户组织编码")
    private String cusOrgCode;

    @ApiModelProperty(value = "客户组织名称")
    private String cusOrgName;

    @ApiModelProperty(value = "终端编码")
    private String terminalCode;

    @ApiModelProperty(value = "终端名称")
    private String terminalName;

    @ApiModelProperty(value = "送达方编码")
    private String deliveryCode;

    @ApiModelProperty(value = "订单分组详情")
    private List<OrderGroupItemVo> groupItemVos;

    @ApiModelProperty(value = "订单附件详情")
    private List<OrderFileVo> files;

    @ApiModelProperty(value = "算价是否成功标识(YesNoEnum)")
    private String calSucessFlag;

    @ApiModelProperty(value = "算价失败提示语")
    private String calSucessMsg;

    @ApiModelProperty(value = "算价失败提示语类型(0->全局，1->分组上，2->行上)")
    private String calSucessMsgType;

    @ApiModelProperty(value = "冗余字段，开始日期")
    private String beginDate;

    @ApiModelProperty(value = "冗余字段，结束日期")
    private String endDate;
}