package com.biz.crm.nebular.fee.pool.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 费用池上账请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolAccountReqVo", description = "费用池上账请求VO")
public class FeePoolAccountReqVo extends CrmExtTenVo {

    @ApiModelProperty("费用池分组，不填表示默认")
    private String poolGroup;

    @ApiModelProperty("费用池类型（必填），来自数据字典fee_pool_type，或者枚举类FeePoolTypeEnum")
    private String poolType;

    @ApiModelProperty("客户编码（必填）")
    private String customerCode;

    @ApiModelProperty("操作类型（必填），来自数据字典fee_pool_operation_type，或者枚举类FeePoolOperationTypeEnum")
    private String operationType;

    @ApiModelProperty("操作金额（必填）")
    private BigDecimal amount;

    @ApiModelProperty("费用使用类型，不填表示默认")
    private String useType;

    @ApiModelProperty("产品层级编码，货补费用池专用")
    private String productLevelCode;

    @ApiModelProperty("商品编码集合，货补费用池专用（如果产品层级编码不为空，则商品必须属于产品层级下）")
    private List<String> productCodeList;

    @ApiModelProperty("来源单号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("附件")
    private List<FeePoolFileReqVo> fileList;

    @ApiModelProperty("（上账表维度）活动编码")
    private String actCode;

    @ApiModelProperty("（上账表维度）活动名称")
    private String actName;

    @ApiModelProperty("（上账表维度）活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("（上账表维度）活动类型")
    private String actType;

    @ApiModelProperty("（上账表维度）活动细类编码")
    private String fineCode;

    @ApiModelProperty("（上账表维度）活动细类名称")
    private String fineName;

    @ApiModelProperty("（上账表维度）活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("（上账表维度）活动大类名称")
    private String categoriesName;

    @ApiModelProperty("（上账表维度）会计科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("（上账表维度）会计科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("（上账表维度）核销编码")
    private String auditCode;

    @ApiModelProperty("（上账表维度）核销明细编码")
    private String auditDetailCode;
}