package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 费用池占用金额全量回退请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolOccupyBackAllReqVo", description = "费用池占用金额全量回退请求VO")
public class FeePoolOccupyBackAllReqVo {

    @ApiModelProperty("来源单号（必填）")
    private String fromCode;

    @ApiModelProperty("操作类型 枚举 FeePoolOperationTypeEnum 或者数据字典 fee_pool_operation_type 默认 12：释放占用")
    private String operationType;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("备注")
    private String remarks;
}