package com.biz.crm.nebular.kms.confadmin.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 商超单据抓取方式返回vo
 *
 * @author Gavin
 * @date 2021-05-06 15:12:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商超单据抓取方式")
public class KmsDirectThreadRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = 1178842232906282394L;
    @ApiModelProperty("商超ID")
    private String directId;

    @ApiModelProperty("单据类型")
    private String orderType;

    @ApiModelProperty("单据类型名称")
    private String orderTypeName;

    @ApiModelProperty("单据下载方式（0_单线程，1_多线程）")
    private Integer orderDownloadWay;

    @ApiModelProperty("单据下载方式（0_单线程，1_多线程）")
    private String orderDownloadWayDesc;

    @ApiModelProperty("原始文件格式（0_EXCEL,1_PDF,2_截屏）")
    private Integer fileClassify;

    @ApiModelProperty("原始文件格式（0_EXCEL,1_PDF,2_截屏）")
    private String fileClassifyDesc;

    @ApiModelProperty("文件下载方式（0_单线程，1_多线程）")
    private Integer fileDownloadWay;

    @ApiModelProperty("文件下载方式（0_单线程，1_多线程）")
    private String fileDownloadWayDesc;

}