package com.biz.crm.nebular.kms.finance.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
/**
 * 稽核模板商超信息请求vo
 *
 * @author Gavin
 * @date 2021-05-25 17:56:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsAuditTemplateDirectReqVo", description = "稽核模板商超信息")
public class KmsAuditTemplateDirectReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 1468070447462816068L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("稽核模版ID")
    private String auditTemplateId;

    @ApiModelProperty("稽核模版ID集合")
    private List<String> auditTemplateIds;

    @ApiModelProperty("商超ID")
    private String directId;

    @ApiModelProperty("商超名称")
    private String directName;

    @ApiModelProperty("容差规则（正_Z/负_F/上下浮动_UD）数据字典：kms_audit_rule")
    private String auditRule;

    @ApiModelProperty("价格允差")
    private BigDecimal differencePrice;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

}