package com.biz.crm.nebular.kms.grabrule.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 单据抓取日志返回vo
 *
 * @author Gavin
 * @date 2021-05-11 11:32:23
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "单据抓取日志")
public class KmsLoggerDataProcessRespVo extends CrmExtTenVo {

    private static final long serialVersionUID = -747752833372083103L;
    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("直营体系ID")
    private String bsDirectSystemId;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("商超网址")
    private String vendorSystemUrl;

    @ApiModelProperty("登录账号")
    private String loginAcc;

    @ApiModelProperty("单据类型名称")
    private String orderTypeName;

    @ApiModelProperty("抓单规则名称")
    private String ruleName;

    @ApiModelProperty("抓单方式（自动抓单，手动抓单）")
    private String style;

    @ApiModelProperty("操作用户")
    private String nickName;

    @ApiModelProperty("抓取状态（0:成功，1：失败）")
    private Integer grabState;

    @ApiModelProperty("抓取结果")
    private String grabMessage;
}