package com.biz.crm.nebular.kms.stockdata.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 库存数据表请求vo
 *
 * @author gavin
 * @date 2021-11-24 14:22:01
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsStockDataReqVo", description = "库存数据表")
public class KmsStockDataReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 2298614538118070272L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("企业库存数据编号")
    private String orderNumber;

    @ApiModelProperty("版本号")
    private Integer versionNumber;

    @ApiModelProperty("商超单据编号")
    private String kaOrderNumber;

    @ApiModelProperty("单据来源")
    private String invoicesSource;

    @ApiModelProperty("商超编码")
    private String kaCode;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("库存日期")
    private String inventoryDate;

    @ApiModelProperty("商超门店/大仓编号")
    private String kaStoreCode;

    @ApiModelProperty("商超门店/大仓名称")
    private String kaStoreName;

    @ApiModelProperty("企业门店/大仓编号")
    private String storeCode;

    @ApiModelProperty("企业门店/大仓名称")
    private String storeName;

    @ApiModelProperty("企业产品编号")
    private String goodsCode;

    @ApiModelProperty("企业产品名称")
    private String goodsName;

    @ApiModelProperty("商超产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("商超产品名称")
    private String kaGoodsName;

    @ApiModelProperty("产品国际条码")
    private String goodsBarCode;

    @ApiModelProperty("产品规格")
    private String specification;

    @ApiModelProperty("库存金额")
    private String inventoryAmount;

    @ApiModelProperty("经营方式")
    private String runMode;

    @ApiModelProperty("门店所属大区编号")
    private String areaCode;

    @ApiModelProperty("门店所属大区名称")
    private String areaName;

    @ApiModelProperty("竞品品牌")
    private String competitiveBrands;

    @ApiModelProperty("商超当前单位层级")
    private String curUnitLevel;

    @ApiModelProperty("商超当前单位")
    private String curUnit;

    @ApiModelProperty("商超当前单位库存数量")
    private String curUnitInventoryQuantity;

    @ApiModelProperty("商超最小单位层级")
    private String minUnitLevel;

    @ApiModelProperty("商超最小单位")
    private String minUnit;

    @ApiModelProperty("商超最小单位库存数量")
    private String minUnitInventoryQuantity;

    @ApiModelProperty("商超最大单位层级")
    private String maxUnitLevel;

    @ApiModelProperty("商超最大单位")
    private String maxUnit;

    @ApiModelProperty("商超最大单位库存数量")
    private String maxUnitInventoryQuantity;

    @ApiModelProperty("业务区域")
    private String businessArea;

    @ApiModelProperty("登录账号")
    private String userName;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("单据当前状态")
    private String orderStatus;

    @ApiModelProperty("单据当前状态信息")
    private String orderStatusMsg;

    @ApiModelProperty("关联ID(企业商品与商超商品表ID)")
    private String goodsRelatedId;

    @ApiModelProperty("企业当前库存单位")
    private String curCompanyUnit;

    @ApiModelProperty("企业当前单位库存数量")
    private String curCompanyUnitOrderQuantity;

}