package com.biz.crm.nebular.mdm.customer;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 请求vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "MdmCustomerDockingReqVo", description = "客户信息：对接人")
@Accessors(chain = true)
public class MdmCustomerDockingReqVo extends CrmExtTenVo {


    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("联系方式")
    private String contact;

    @ApiModelProperty("用户帐号")
    private String userName;

    @ApiModelProperty("用户名称")
    private String fullName;

    @ApiModelProperty("销售公司编码")
    private String saleCompany;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("客户供货关系列表")
    private List<MdmCustomerSupplyDetailReqVo> mdmCustomerSupplyDetailVos;

    @ApiModelProperty("对接人商品信息列表")
    private List<CustomerProductReqVo> customerProductReqVos;
}