package com.biz.crm.nebular.mdm.customer;
import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 客户信息销售区域请求vo
 *
 * @author zxw
 * @date 2020-11-16 15:50:20
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmCustomerSaleAreaReqVo", description = "客户信息销售区域")
public class MdmCustomerSaleAreaReqVo extends CrmTreeTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("一级区域")
    private String areaOne;

    @ApiModelProperty("二级区域")
    private String areaTwo;

    @ApiModelProperty("三级区域")
    private String areaThree;

    @ApiModelProperty("品牌")
    private String brand;

}