package com.biz.crm.nebular.mdm.material;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "物料管理返回VO")
@CrmColumnResolve
public class MdmMaterialRespVo extends CrmExtVo {

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    private String materialName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("AI编码")
    private String aiCode;

    @ApiModelProperty("条形码")
    private String barCode;

    @ApiModelProperty("基本单位")
    private String baseUnit;

    @ApiModelProperty("基本单位")
    @CrmDict(typeCode = "material_base_unit", dictCodeField = "baseUnit")
    private String baseUnitName;

    @ApiModelProperty("物料类型")
    private String materialType;

    @ApiModelProperty("物料类型")
    @CrmDict(typeCode = "material_type", dictCodeField = "materialType")
    private String materialTypeName;

    @ApiModelProperty("销售公司编码（列表显示用）。多个编码用逗号隔开")
    private String saleCompany;

    @ApiModelProperty("销售公司（新增入参和编辑回传）")
    private List<String> saleCompanyList;

    @ApiModelProperty("销售公司名称（列表显示用），多个名称用逗号隔开")
    private String saleCompanyName;

    @ApiModelProperty("销售单位")
    private String saleUnit;

    @ApiModelProperty("销售单位")
    @CrmDict(typeCode = "material_sale_unit", dictCodeField = "saleUnit")
    private String saleUnitName;

    @ApiModelProperty("规格")
    private String specification;

    @ApiModelProperty("单位换算系数")
    private String unitConversion;

    @ApiModelProperty("成本价格")
    private String costPrice;

    @ApiModelProperty("毛重")
    private String grossWeight;

    @ApiModelProperty("净重")
    private String netWeight;

    @ApiModelProperty("容量")
    private String capacity;

    @ApiModelProperty("主图片")
    private String imgUrl;

    /**
     * 标准单位
     */
    @ApiModelProperty("标准单位")
    private String standardUnit;

    /**
     * 盒码单位转算系数
     */
    @ApiModelProperty("盒码单位转算系数")
    private BigDecimal boxUnitConversion;

    /**
     * 箱码单位转算系数
     */
    @ApiModelProperty("箱码单位转算系数")
    private BigDecimal caseUnitConversion;

    /**
     * 照片信息
     */
    @ApiModelProperty("照片信息")
    private List<MdmMaterialMediaRespVo> picList;

    /**
     * 产品层级信息
     */
    @ApiModelProperty("产品层级信息")
    List<MdmProductLevelVo> productLevels;
}