package com.biz.crm.nebular.mdm.pageconfig;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 功能列表与按钮关联表返回vo
 *
 * @author zxw
 * @date 2020-12-05 12:56:52
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "功能列表与按钮关联表")
@SaturnEntity(name = "MdmFunctionSubButtonRespVo", description = "功能列表与按钮关联表")
public class MdmFunctionSubButtonRespVo extends CrmExtTenVo {

    @ApiModelProperty("按钮编码")
    @SaturnColumn(description = "按钮编码")
    private String buttonCode;

    @ApiModelProperty("询问语")
    @SaturnColumn(description = "询问语")
    private String ask;

    @ApiModelProperty("功能查询地址")
    @SaturnColumn(description = "功能查询地址")
    private String queryUrl;

    @ApiModelProperty("url")
    @SaturnColumn(description = "url")
    private String apiUrl;

    @ApiModelProperty("按钮操作类型")
    @SaturnColumn(description = "按钮操作类型")
    private String buttonOperationType;

    @ApiModelProperty("上级菜单编码")
    @SaturnColumn(description = "上级菜单编码")
    private String parentCode;

    @ApiModelProperty("功能列表编码")
    @SaturnColumn(description = "功能列表编码")
    private String functionCode;

    @ApiModelProperty("功能列表名称")
    private String functionName;

    @ApiModelProperty("按钮名称")
    private String buttonName;

    @ApiModelProperty("排序")
    @SaturnColumn(description = "排序")
    private Integer buttonOrder;

    @ApiModelProperty("功能编码")
    @SaturnColumn(description = "功能编码")
    private String doCode;

    @ApiModelProperty("显示模式：true显示，false隐藏")
    @SaturnColumn(description = "显示模式：true显示，false隐藏")
    private String visible;

    @ApiModelProperty("导入按钮编码")
    private String configCode;

}