package com.biz.crm.nebular.mdm.position.req;

import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 职位管理列表请求VO
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPositionPageReqVo", description = "职位管理列表请求VO")
public class MdmPositionPageReqVo extends CrmTreeTenVo {

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("关联组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别名称")
    private String positionLevelName;

    @ApiModelProperty("是否主职位1是0否")
    private String primaryFlag;

    @ApiModelProperty("用户登录名")
    private String userName;

    @ApiModelProperty("用户姓名")
    private String fullName;

    @Deprecated
    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("上级职位编码")
    private String parentCode;

    @ApiModelProperty("上级职位名称")
    private String parentName;

    @ApiModelProperty("上级用户编码")
    private String parentUserName;

    @ApiModelProperty("上级用户名称")
    private String parentFullName;

    @ApiModelProperty("上级用户编码")
    private String parentUserCode;

    @ApiModelProperty("上级组织编码")
    private String parentOrgCode;

    @ApiModelProperty("上级组织名称")
    private String parentOrgName;

    @ApiModelProperty("角色名称，英文逗号间隔")
    private String roleName;

    @ApiModelProperty("角色编码，英文逗号间隔")
    private String roleCode;

    @ApiModelProperty("组织树编码")
    private String code;

    /***组织降维编码，查询这个组织及下级组织的职位*/
    private String orgRuleCode;

    @ApiModelProperty("过滤职位编码集合")
    private List<String> includePositionCodeList;

    @ApiModelProperty("过滤的职位编码集合")
    private List<String> excludePositionCodeList;
}