package com.biz.crm.nebular.mdm.position.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPositionRelationTerminalPageRespVo", description = "职位-终端关联返回VO")
@CrmColumnResolve
public class MdmPositionRelationTerminalPageRespVo extends CrmExtVo {

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("终端类型")
    private String terminalType;

    @Deprecated
    @ApiModelProperty("终端类型名称")
    @CrmDict(typeCode = DictConstant.TERMINAL_TYPE, dictCodeField = "terminalType")
    private String terminalTypeName;

    @ApiModelProperty("省编码")
    private String provinceCode;

    @ApiModelProperty("市编码")
    private String cityCode;

    @ApiModelProperty("区编码")
    private String districtCode;

    @ApiModelProperty("省名称")
    private String provinceName;

    @ApiModelProperty("市名称")
    private String cityName;

    @ApiModelProperty("区名称")
    private String districtName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("终端地址")
    private String terminalAddress;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("supply表id")
    private String supplyId;
}
