package com.biz.crm.nebular.mdm.pricesetting.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 价格查询入参
 *
 * @author huanglong
 * @date 2020-10-20 13:49:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPriceSearchReqVo", description = "价格查询入参 ")
public class MdmPriceSearchReqVo extends CrmExtVo {

    @ApiModelProperty("时间,精确年月日，格式yyyy-MM-dd")
    private String searchTime;

    @ApiModelProperty("商品编码集合")
    private List<String> productCodeList;

    @ApiModelProperty("条件类型编码集合")
    private List<String> conditionTypeCodeList;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("价格组")
    private String priceGroup;

    @ApiModelProperty("销售公司编码")
    private String saleCompanyCode;

    @ApiModelProperty("币种编码(字典currency_type)")
    private String currencyType;

    @ApiModelProperty("币种名称")
    private String currencyTypeName;

    @ApiModelProperty("单位类型 数据字典：unit_type")
    private String unitType;

    @ApiModelProperty("价格单位(字典,选项数据跟选择的商品有关)")
    private String priceUnit;

    @ApiModelProperty("价格单位名称")
    private String priceName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("客户类型")
    private String customerType;

    @ApiModelProperty("终端类型")
    private String terminalType;

}