package com.biz.crm.nebular.mdm.product.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * mdm侧商品分页查询dto
 *
 * @Author: hecheng
 */
@Data
@ApiModel
public class ProductMdmPaginationDto implements Serializable {

  private static final long serialVersionUID = 925824147679953235L;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品层级编码
   * <pre>
   *   "brand":"品牌"
   *   "series":"系列"
   *   "max":"大类"
   *   "min":"细类"
   * </pre>
   */
  @ApiModelProperty("商品层级类型")
  private String productLevelType;
  /**
   * 商品层级编码集合
   */
  @ApiModelProperty("商品层级编码集合")
  private List<String> productLevelCodes;

  /**
   * 物料编码集合
   */
  @ApiModelProperty("物料编码集合")
  private List<String> materialCodes;
  /**
   * 修改开始时间
   */
  @ApiModelProperty("修改开始时间")
  private Date modifyStartDate;
  /**
   * 修改结束时间
   */
  @ApiModelProperty("修改结束时间")
  private Date modifyEndDate;
}
