package com.biz.crm.nebular.mdm.product.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 商品下拉框返回VO
 *
 * @author huang.long
 * @date 2020-08-28 16:07:20
 */
@Data
@ApiModel(value = "商品下拉框返回VO")
public class MdmProductSelectRespVo extends CrmExtVo {

    private static final long serialVersionUID = -8859040882192762918L;
    @ApiModelProperty("商品名称+商品名称")
    private String productCodeName;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("商品类型(数据字典)")
    private String productType;

    @ApiModelProperty("商品类型")
    @CrmDict( typeCode = "product_type", dictCodeField = "productType")
    private String productTypeName;

    @ApiModelProperty("销售单位(字典编码)")
    private String saleUnit;

    @ApiModelProperty("销售单位")
    @CrmDict( typeCode = "product_sale_unit", dictCodeField = "saleUnit")
    private String saleUnitName;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("基本单位(字典编码)")
    private String baseUnit;

    @ApiModelProperty("基本单位")
    @CrmDict( typeCode = "product_base_unit", dictCodeField = "baseUnit")
    private String baseUnitName;

    @ApiModelProperty("开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    private String endDateSecond;

    @ApiModelProperty("上下架状态(数据字典)")
    private String isShelf;

    @ApiModelProperty("上下架状态")
    @CrmDict( typeCode = "is_shelf", dictCodeField = "isShelf")
    private String isShelfName;

    @ApiModelProperty("条形码")
    private String barCode;

}