package com.biz.crm.nebular.mdm.terminal.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 终端下拉框请求VO
 *
 * @Author Tao.Chen
 * @Date 2020/12/22 17:30:11
 */
@Data
@ApiModel(value = "终端下拉框请求参数")
public class MdmTerminalSelectReqVo {

    @ApiModelProperty("返回条数，不传返回默认数量")
    private Integer pageSize;

    @ApiModelProperty("启用状态，精确查询")
    private String enableStatus;

    @ApiModelProperty("审批状态，精确查询")
    private String actApproveStatus;

    @ApiModelProperty("终端编码：模糊查询")
    private String terminalCode;

    @ApiModelProperty("终端名称：模糊查询")
    private String terminalName;

    @ApiModelProperty("终端编码/终端名称：模糊查询")
    private String unionName;

    @ApiModelProperty("账号")
    private String userName;

    @ApiModelProperty("选择来源， 1：终端用户新增编辑——关联终端选择")
    private String chooseSource;

    @ApiModelProperty("模糊查询编码或者名称")
    private String terminalCodeOrName;

    @ApiModelProperty("终端类型：精确查询")
    private String terminalType;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodeList;

}
