package com.biz.crm.nebular.sfa.asexecution.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemePosApplyRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Map;

/**
 * 方案活动执行详情查询;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "方案活动执行详情查询;")
@SaturnEntity(name = "SfaAsExecutionDetailRespVo", description = "方案活动执行详情查询;")
public class SfaAsExecutionDetailRespVo {

    @ApiModelProperty("参与类型(1:免费参与;2:协议参与)")
    @SaturnColumn(description = "终端编码")
    private String participateInType;

    @ApiModelProperty("活动明细")
    @SaturnColumn(description = "活动明细")
    private SfaActSchemePosApplyRespVo actSchemePosApply;

    @ApiModelProperty("方案活动执行记录")
    @SaturnColumn(description = "方案活动执行记录")
    private List<SfaAsExecutionRespVo> asExecutionList;

    @ApiModelProperty("方案活动协议记录")
    @SaturnColumn(description = "方案活动协议记录")
    private SfaAsTreatyRespVo asTreaty;

    @ApiModelProperty("方案活动兑付记录")
    @SaturnColumn(description = "方案活动兑付记录")
    private SfaAsCashingRespVo asCashing;

    @ApiModelProperty("方案活动终止记录")
    @SaturnColumn(description = "方案活动终止记录")
    private SfaAsStopRespVo asStop;

}