package com.biz.crm.nebular.sfa.integral.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 积分明细报表——Vo
 * @author YuanZiJian
 * @date 2021/1/12 10:25
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaIntegralDetailRespVo", description = "积分明细报表 ")
public class SfaIntegralDetailRespVo extends CrmExtTenVo {

    @ApiModelProperty("所属积分规则编码")
    private  String integralRuleCode;

    @ApiModelProperty("所属积分规则Id")
    private String integralRuleId;

    @ApiModelProperty("所属积分规则名称")
    private String integralRuleName;

    @ApiModelProperty("积分数")
    private Integer integralNum;

    @ApiModelProperty("所属计算规则类型")
    private String integralTaskType;


    @ApiModelProperty("所属计算规则名字")
    @CrmDict(typeCode = "integral_task",dictCodeField = "integralTaskType")
    private String integralTaskName;

    @ApiModelProperty("人员编码")
    private String userName;

    @ApiModelProperty("人员名字")
    private String fullName;

    @ApiModelProperty("职位等级编码")
    private String posCode;

    @ApiModelProperty("职位等级名称")
    private String posName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;
}
