package com.biz.crm.nebular.sfa.moblie.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 经销商新增修改接收VO
 * @author YuanZiJian
 * @date 2021/3/9 19:00
 * @version: V1.0
 */
@Data
@ApiModel(value = "SfaCustomerMsgReqVo", description = "经销商新增修改接收VO")
@Accessors(chain = true)
public class SfaCustomerMsgReqVo extends CrmExtTenVo {

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户组织")
    private String customerOrgName;

    @ApiModelProperty("客户类型")
    private String customerType;

    @ApiModelProperty("所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织")
    private String orgName;

    @ApiModelProperty("注册地址")
    private String registeredAddress;

    @ApiModelProperty("客户联系方式")
    private String customerContact;

    @ApiModelProperty("客户法人代表")
    private String legalRepresentative;

    @ApiModelProperty("对接人列表")
    private List<MdmCustomerDockingReqVo> mdmCustomerDockingVos;

    @ApiModelProperty("联系人列表")
    private List<MdmCustomerContactReqVo> mdmCustomerContactVos;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("审批状态,枚举ActApproveStatusEnum")
    private String actApproveStatus;

}
