package com.biz.crm.nebular.sfa.tpmact.resp;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReportReqVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.nebular.sfa.tpmact.resp
 * @date 2021/6/18 17:04
 */
@Data
@ApiModel(value = "SfaTpmActReportRespVo", description = "tpm活动拜访步骤报表返回vo")
public class SfaTpmActReportRespVo extends SfaTpmActRespVo implements Serializable {

    public static final String REDIS_HASH_KEY = "SFA_VISIT_STEP_TPM_REPORT";

    public static final Long REDIS_EXPIRE_TIME = Long.valueOf(60*60*24);

    @ApiModelProperty("协议pdf地址")
    private String treatyPdfUrl;

    @ApiModelProperty("协议pdf-图片前缀-ip地址")
    private String urlPathPrefix;

    @ApiModelProperty("协议pdf-图片对象名称")
    private String objectName;

    @ApiModelProperty("协议pdf-图片相对路径")
    private String urlPath;

    @ApiModelProperty("审批状态")
    private String approveStatus;

    @ApiModelProperty("核销金额")
    private BigDecimal auditAmount;

    @ApiModelProperty("支付方式名称")
    private String payTypeName;

    @ApiModelProperty("分销订单")
    private DistributionOrder distributionOrder;

    @ApiModelProperty("活动数据采集")
    private ActCollectData actCollectData;


    @Data
    @ApiModel(value = "DistributionOrder", description = "分销订单")
    public static class DistributionOrder {

        @ApiModelProperty("本品商品集合")
        private List<DistributionOrderItem> bpProductList;

        @ApiModelProperty("赠品商品集合")
        private List<DistributionOrderItem> zpProductList;
    }

    @Data
    @ApiModel(value = "DistributionOrderItem", description = "分销订单行项目商品")
    public static class DistributionOrderItem {

        @ApiModelProperty("产品编码")
        private String productCode;

        @ApiModelProperty("产品名称")
        private String productName;

        @ApiModelProperty("数量")
        private BigDecimal quantity;

        @ApiModelProperty("单位")
        private String unit;

        @ApiModelProperty("单位")
        private String unitName;

        @ApiModelProperty("商品单价")
        private BigDecimal price;
    }

    @Data
    @ApiModel(value = "ActCollectData", description = "活动数据采集")
    public static class ActCollectData {

        @ApiModelProperty("活动数据采集列表")
        private List<CollectForm> collectFormList;

        @ApiModelProperty("活动描述")
        private String actDesc;
    }


    @Data
    @ApiModel(value = "CollectForm", description = "动态表单-拍照图片")
    public static class CollectForm {

        @ApiModelProperty("表单名称")
        private String exampleName;

        @ApiModelProperty("表单编码")
        private String exampleCode;

        @ApiModelProperty("图片")
        private List<AttachmentVo> attachmentList;

    }

    /**
     * 组装redisKey
     * @return
     */
    public static String buildRedisHashKey(SfaTpmActReportReqVo reqVo){
        StringJoiner redisKey = new StringJoiner(RedisParam.DELIMITER);
        return redisKey.add(REDIS_HASH_KEY).add(reqVo.getVisitPlanInfoId()).add(reqVo.getTerminalCode()).add(reqVo.getActDetailCode()).toString();
    }


    public static Map<String,SfaTpmActReportRespVo> buildRedisMap(SfaTpmActReportRespVo respVo){
        Map<String,SfaTpmActReportRespVo> map = new HashMap<>();
        map.put(REDIS_HASH_KEY,respVo);
        return map;
    }
}
