package com.biz.crm.nebular.sfa.worksign.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 请假申请 返回vo
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "请假申请 ")
@SaturnEntity(name = "SfaLeaveRespVo", description = "请假申请 ")
public class SfaLeaveRespVo extends CrmExtTenVo {
    @ApiModelProperty("请假类型 请假类型")
    @SaturnColumn(description = "请假类型 请假类型")
    private String leaveType;

    @ApiModelProperty("请假类型名称")
    private String leaveTypeName;

    @ApiModelProperty("请假事由 请假事由")
    @SaturnColumn(description = "请假事由 请假事由")
    private String leaveReason;

    @ApiModelProperty("人员账号 人员账号")
    @SaturnColumn(description = "人员账号 人员账号")
    private String userName;

    @ApiModelProperty("人员姓名 人员姓名")
    @SaturnColumn(description = "人员姓名 人员姓名")
    private String realName;

    @ApiModelProperty("职位编码 职位编码")
    @SaturnColumn(description = "职位编码 职位编码")
    private String posCode;

    @ApiModelProperty("职位名称 职位名称")
    @SaturnColumn(description = "职位名称 职位名称")
    private String posName;

    @ApiModelProperty("所属组织编码 所属组织编码")
    @SaturnColumn(description = "所属组织编码 所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织名称 所属组织名称")
    @SaturnColumn(description = "所属组织名称 所属组织名称")
    private String orgName;

    @ApiModelProperty("申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
    @SaturnColumn(description = "申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
    private String applicationDate;

    @ApiModelProperty("开始时间 开始时间(yyyy-MM-dd HH)")
    @SaturnColumn(description = "开始时间 开始时间(yyyy-MM-dd HH)")
    private String beginTime;

    @ApiModelProperty("结束时间 结束时间(yyyy-MM-dd HH)")
    @SaturnColumn(description = "结束时间 结束时间(yyyy-MM-dd HH)")
    private String endTime;

    @ApiModelProperty("审批状态 审批状态")
    @SaturnColumn(description = "审批状态 审批状态")
    private String bpmStatus;

    @ApiModelProperty("审批状态名称")
    private String bpmStatusName;

    @ApiModelProperty("日期明细json")
    private String timeInfoListJson;

    @ApiModelProperty("请假时长(天)")
    private String leaveDuration;

    @ApiModelProperty("附件列表json")
    private String attachmentListJson;

    @ApiModelProperty("销假天数")
    private String cancelDays;

    @ApiModelProperty("审核任务id")
    private String auditTaskId;

    @ApiModelProperty("销假列表")
    private List<SfaLeaveCancelRespVo> leaveCancelRespVoList;

    @ApiModelProperty("非工作日")
    private String nonWorkDateListJson;

    @ApiModelProperty("是否可以操作销假(Y是)")
    private String operationCancel;

    @ApiModelProperty("流程编码")
    private String processNo;

}