package com.biz.crm.nebular.tpm.sale.req;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 销售计划 请求vo
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmSalesPlansReqVo", description = "销售计划 ")
public class TpmSalesPlansReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;


    @ApiModelProperty("岗位编码")
    private String positionCode;

    @ApiModelProperty("岗位名称")
    private String positionName;

    @ApiModelProperty("年")
    private String spYear;

    @ApiModelProperty("月")
    private String spMonth;

    @ApiModelProperty("类型")
    private String spType;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("金额")
    private BigDecimal amount;

    @ApiModelProperty("币种")
    private String currencyTypes;

    @ApiModelProperty("销售计划id")
    private String salePlansId;

}