package com.biz.crm.eunm;

import com.biz.crm.base.BusinessException;
import com.biz.crm.util.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:crm数据业务状态
 * @Author: zhangyuzhu
 * @Date: 2020/8/20 18:25
 **/
public enum CrmEnableStatusEnum {
    /**
     * 编码与描述
     */
    DISABLE("003","禁用"),
    ENABLE("009","启用");

    private String code;
    private String des;

    CrmEnableStatusEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (CrmEnableStatusEnum crmEnableStatusEnum : CrmEnableStatusEnum.values()) {
            codes.add(crmEnableStatusEnum.getCode());
        }
        return codes;
    }

    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            CrmEnableStatusEnum[] values = CrmEnableStatusEnum.values();
            for (CrmEnableStatusEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * code转数组
     * @return
     */
    public static void validateEnableStatus(String enableStatus){
        if(!CrmEnableStatusEnum.codeToSet().contains(enableStatus)){
            throw new BusinessException("数据业务状态错误！");
        }
    }
}
