package com.biz.crm.eunm.sfa;

import jodd.util.StringUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:sfa     考勤常量
 * @Author: liuhongming
 * @Date: 2020/9/21 18:25
 **/
public class SfaWorkSignEnum {


    /**
     * 规则类型
     */
    public enum WorkSignRuleType {
        R0("0","自由签到"), //自由签到
        R1("1","固定时间上下班规则"), //固定时间上下班规则
        R2("2","自由时间上下班规则"); //自由时间上下班规则
        private String val;
        private String desc;

        WorkSignRuleType(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 电子围栏
     */
    public enum electronFenceEnum {
        F1("1","允许范围外打卡，地点记录为异常"), //允许范围外打卡，地点记录为异常
        F2("2","允许范围外打卡，地点记录为正常"), //允许范围外打卡，地点记录为正常
        F3("3","不允许范围外打卡");
        private String val;
        private String desc;

        electronFenceEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 签到地点状态
     */
    public enum wsPlaceStatusEnum {
        P1("1","正常"),
        P2("2","异常");
        private String val;
        private String desc;

        wsPlaceStatusEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 工作日
     */
    public enum workingDayEnum {
        Mon("1","星期一"),
        Tues("2","星期二"),
        Wed("3","星期三"),
        Thur("4","星期四"),
        Fri("5","星期五"),
        Sat("6","星期六"),
        Sun("7","星期日");
        private String val;
        private String desc;

        workingDayEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 节假日(1：同步中国节假日节假日期间不用打卡)
     */
    public static String isHolidayWhether = "1";

    /**
     * 拍照打卡(1:员工打卡时必须拍照)
     */
    public static String isWsrPhotograph = "1";

    /**
     * 下班	(1:下班不需要打卡;2:下班需要打卡，且必须打上班卡才能打下班卡;3:下班需要打卡，无需打上班卡，就能打下班卡)
     */
    public enum gooffWorkEnum {
        One("1","下班不需要打卡"),
        Two("2","下班需要打卡，且必须打上班卡才能打下班卡"),
        Three("3","下班需要打卡，无需打上班卡，就能打下班卡");
        private String val;
        private String desc;

        gooffWorkEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 特殊日期 - 类型
     */
    public enum workSignSpecialType{
        One("1","必须打卡的日期"),
        Two("2","不用打卡的日期");
        private String val;
        private String desc;

        workSignSpecialType(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 打卡类型
     */
    public enum WorkSignType {
        R1("1","上班签到"), //固定时间上下班规则
        R2("2","下班签退"); //自由时间上下班规则
        private String val;
        private String desc;

        WorkSignType(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 签到签退状态 0:未打卡;1:正常;2:迟到;3:早退;
     */
    public enum workSignState {
        S1("1","正常"), //固定时间上下班规则
        S2("2","迟到"),
        S3("3","早退"),
        S0("0","未打卡"); //自由时间上下班规则
        private String val;
        private String desc;

        workSignState(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }



}
