package com.biz.crm.eunm.tpm;

import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:crm 活动审批状态枚举
 * @Author: huanglong
 * @Date: 2020/8/20 18:25
 **/
public enum ActApproveStatusEnum {
    CREATE("create","待提交"),
    APPROVING("approving","审批中"),
    APPROVED("approved","审批通过"),
    REJECTED("rejected","审批驳回"),
    INTERRUPT("interrupt","流程追回"),
    CLOSED("closed","活动关闭"),
    ;



    private String code;
    private String des;

    ActApproveStatusEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    public static String getStatusName(String code){
        ActApproveStatusEnum[] values = ActApproveStatusEnum.values();
        String desc=null;
        for (ActApproveStatusEnum o : values){
            if(StringUtils.equals(o.getCode(),code)){
                desc=o.getDes();
                break;
            }
        }
        return desc;
    }
    /**
     * 可以发起审批的状态
     * @return
     */
    public static Set<String> getCanApproveStatus(){
        Set<String> set = new HashSet<>();
        set.add(ActApproveStatusEnum.CREATE.code);
        set.add(ActApproveStatusEnum.REJECTED.code);
        set.add(ActApproveStatusEnum.INTERRUPT.code);
        return set;
    }
}
