package com.biz.crm.eunm.tpm;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:crm 活动保存类型枚举
 * @Author: huanglong
 * @Date: 2020/8/20 18:25
 **/
public enum ActSaveTypeEnum {
    ADD("1","新增暂存"),
    ADD_AND_APPROVE("2","新增并提交审批"),
    UPDATE("3","修改暂存"),
    UPDATE_AND_APPROVE("4","修改并提交审批"),
    APPROVE("5","提交审批"),

    ;



    private String code;
    private String des;

    ActSaveTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    /**
     * 新增操作
     * @return
     */
    public static Set<String> getSaveTypes(){
        Set<String> set=new HashSet<String>();
        set.add(ActSaveTypeEnum.ADD.getCode());
        set.add(ActSaveTypeEnum.ADD_AND_APPROVE.getCode());
        return set;
    }

    /**
     * 修改操作
     * @return
     */
    public static Set<String> getUpdateTypes(){
        Set<String> set=new HashSet<String>();
        set.add(ActSaveTypeEnum.UPDATE.getCode());
        set.add(ActSaveTypeEnum.UPDATE_AND_APPROVE.getCode());
        return set;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

}
