package com.biz.crm.util;

import com.alibaba.excel.util.CollectionUtils;
import com.biz.crm.dict.feign.MdmKnlDictFeign;
import com.biz.crm.service.RedisService;
import lombok.extern.slf4j.Slf4j;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author zxw
 **/
@Slf4j
public class DictUtil {

    private static RedisService redisService;

    private static MdmKnlDictFeign mdmKnlDictFeign;

    public static void setMdmKnlDictFeign(MdmKnlDictFeign feign) {
        mdmKnlDictFeign = feign;
    }

    public static void setRedisService(RedisService redis) {
        redisService = redis;
    }


    /**
     * 根据字典主表code集合查询对应的value的map集合
     *
     * @param dictTypeCodes 分类编码集合
     * @return map
     */
    public static Map<String, Map<String, String>> getDictValueMapsByCodes(List<String> dictTypeCodes) {
        try {
            if (CollectionUtils.isEmpty(dictTypeCodes)) {
                return Collections.emptyMap();
            }
            return mdmKnlDictFeign.typeList(dictTypeCodes);
        } catch (Exception e) {
            log.error("{}",e);
        }
        return Collections.emptyMap();
    }

    /**
     * 根据分类编码查询map
     *
     * @param typeCode 分类编码
     * @return map
     */
    public static Map<String, String> getDictValueMapsByCodes(String typeCode) {
        return mdmKnlDictFeign.list(typeCode);
    }


    /**
     * 查询字典值
     *
     * @param dictCode     字典对象编码
     * @param dictTypeCode 字典分类编码
     * @return 字典值
     */
    public static String getDictDataVal(String dictTypeCode, String dictCode) {
        return mdmKnlDictFeign.val(dictTypeCode, dictCode);
    }

    /**
     * 查询字典对象
     *
     * @param dictTypeCode 字典分类编码
     * @return map
     */
    public static Map<String, String> dictMap(String dictTypeCode) {
        return mdmKnlDictFeign.list(dictTypeCode);
    }


}
