package com.biz.crm.base;


import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;


import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Description: 基本字段entity，用于每个表
 * @Author: zhangyuzhu
 * @Date: 2020/8/19 10:01
 **/
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CrmBaseEntity<T> extends BaseIdEntity implements Serializable {

    private static final long serialVersionUID = -3517167521124118330L;
    /**
     * 数据状态（删除状态）
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "del_flag", length = 10 ,order = -121)
    private String delFlag;

    /**
     * 数据业务状态（启用状态）
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "enable_status", length = 10,order = -120)
    private String enableStatus;

    /**
     * 创建时间 yyyy-mm-dd
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "create_date", length = 20,order = -119)
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String createDate;
    /**
     * 创建时间 hh:mm:ss
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "create_date_second", length = 20,order = -118)
    @Field(type = FieldType.Date, format = DateFormat.hour_minute_second)
    private String createDateSecond;



    /**
     * 创建人账号
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "create_code", length = 60,order = -117)
    private String createCode;

    /**
     * 创建人名称
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "create_name", length = 60,order = -116)
    private String createName;

    /**
     * 创建人组织编码
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "create_org_code", length = 40,order = -115)
    private String createOrgCode;

    /**
     * 创建人组织名称
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "create_org_name", length = 60,order = -114)
    private String createOrgName;

    /**
     * 创建人职位code
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "create_pos_code", length = 40,order = -113)
    private String createPosCode;

    /**
     * 创建人职位名称
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "create_pos_name", length = 60,order = -112)
    private String createPosName;

    /**
     * 修改时间 yyyy-mm-dd
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "update_date", length = 20,order = -111)
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String updateDate;

    /**
     * 更新时间 hh:mm:ss
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "update_date_second", length = 20,order = -110)
    @Field(type = FieldType.Date, format = DateFormat.hour_minute_second)
    private String updateDateSecond;

    /**
     * 修改人账号
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "update_code", length = 40,order = -109)
    private String updateCode;

    /**
     * 修改人名称
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "update_name", length = 60,order = -108)
    private String updateName;

    /**
     * 修改人组织编码
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "update_org_code", length = 40,order = -107)
    private String updateOrgCode;

    /**
     * 修改人组织名称
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "update_org_name", length = 60,order = -106)
    private String updateOrgName;

    /**
     * 修改人职位code
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "update_pos_code", length = 40,order = -105)
    private String updatePosCode;

    /**
     * 修改人职位名称
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "update_pos_name", length = 60,order = -104)
    private String updatePosName;


    /**
     * 备注
     */
    @CrmColumn(name = "remarks", length = 400,order = -103)
    private String remarks;

    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "update_date_all", length = 40,note = "修改时间完整",order = -102)
    private String updateDateAll;
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @CrmColumn(name = "create_date_all", length = 40,note = "创建时间完整",order = -101)
    private String createDateAll;
    /**
     * 判断数据状态是否正常
     * @return
     */
    @JsonIgnore
    public boolean isNormal(){
        if(StringUtils.equals(CrmDelFlagEnum.NORMAL.getCode(),this.delFlag)){
            return true;
        }
        return false;
    }

    /**
     * 数据状态删除
     * @return
     */
    public T delete(){
        this.delFlag = CrmDelFlagEnum.DELETE.getCode();
        return (T) this;
    }

    /**
     * 数据状态正常
     * @return
     */
    public T normal(){
        this.delFlag = CrmDelFlagEnum.NORMAL.getCode();
        return (T) this;
    }

    /**
     * 业务状态启用
     * @return
     */
    public T enable(){
        this.enableStatus = CrmEnableStatusEnum.ENABLE.getCode();
        return (T) this;
    }

    /**
     * 业务状态禁用
     * @return
     */
    public T disable(){
        this.enableStatus = CrmEnableStatusEnum.DISABLE.getCode();
        return (T) this;
    }



    public static void buildDefEntityData(CrmBaseEntity entity){
        UserRedis userRedis = UserUtils.getUser();
        entity.setCreateCode(userRedis.getUsername());
        entity.setCreateName(userRedis.getRealname());
        LocalDateTime now = LocalDateTime.now();
        entity.setCreateDate(now.format(CrmDateUtils.yyyyMMdd));
        entity.setCreateDateSecond(now.format(CrmDateUtils.HHmmss));
        entity.setCreateOrgCode(userRedis.getOrgcode());
        entity.setCreateOrgName(userRedis.getOrgname());
        entity.setCreatePosCode(userRedis.getPoscode());
        entity.setCreatePosName(userRedis.getPosname());
    }
}
