package com.biz.crm.base;


import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.util.CodeUtil;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;



/**
 * @Description: 适用于所有CRM树形entity的字段
 * @Author: zhangyuzhu
 * @Date: 2020/8/19 15:57
 **/
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CrmTreeEntity<T> extends CrmExtEntity<T>{

    /**
     * 规则code查询用
     */
    @CrmColumn(name = "rule_code", length = 200,order = -90)
    private String ruleCode;

    /**
     * 层级等级查询用
     */
    @CrmColumn(name = "level_num",mysqlType = "int(11)", oracleType = "NUMBER(11,0)",note = "层级等级查询用",order = -91)
    private Integer levelNum;

    /**
     * 设置规则code
     * @param parentRuleCode 父节点ruleCode
     * @param brotherNum 有效兄弟节点数量
     * @return
     */
    public T ruleCode(String parentRuleCode,int brotherNum){
        this.ruleCode = CodeUtil.fullThree(parentRuleCode,brotherNum + 1);
        return (T) this;
    }

    /**
     * 设置等级
     * @param levelNum 等级
     * @return
     */
    public T levelNum(int levelNum){
        this.levelNum = levelNum;
        return (T) this;
    }
}
