package com.biz.crm.eunm.mdm;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zxw
 * @date 2021-03-01 09:00
 **/
@AllArgsConstructor
@Getter
public enum KmsInvoiceSourceEnum {

    /**
     *
     */
    AUTOMATIC_GRAB("0", "自动抓单"),
    MANUAL_GRAB("1", "手动抓单"),
    MANUAL_ADD("2", "手动添加"),
    TABLE_IMPORT("3", "表格导入"),
    ;

    private final String code;
    private final String value;

    public static String findCodeByValue(String value) {
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        KmsInvoiceSourceEnum[] values = values();
        for (KmsInvoiceSourceEnum kmsInvoiceSourceEnum : values) {
            if (kmsInvoiceSourceEnum.getValue().equals(value)) {
                return kmsInvoiceSourceEnum.getCode();
            }
        }
        return null;
    }
}
