package com.biz.crm.eunm.mdm;

import java.util.HashMap;
import java.util.Map;

/**
 * 公告状态枚举
 * @author yangshan
 * @date 2021/4/14 0:47
 */
public class MdmNoticeStatusEnum {

    /**
     * 公告置顶状态
     */
    public enum NoticeTopStatus {
        TOP("1","置顶"),
        CANCEL_TOP("0","未置顶")
        ;
        private String val;
        private String desc;

        NoticeTopStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (MdmNoticeStatusEnum.NoticeTopStatus type : MdmNoticeStatusEnum.NoticeTopStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 公告评论状态
     */
    public enum NoticeCommentStatus {
        YES("1","可评论"),
        NOT("0","不可评论")
        ;
        private String val;
        private String desc;

        NoticeCommentStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (MdmNoticeStatusEnum.NoticeCommentStatus type : MdmNoticeStatusEnum.NoticeCommentStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}
