package com.biz.crm.eunm.sfa;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:
 * @project：crm
 * @package：com.biz.crm.enums
 * @author：lifei
 * @create：2020/11/27 11:13 上午
 */
public class SfaCodeEnum {

    /**
     * 公告编码
     */
    public enum NoticeCode {
        SFA_NOTICE_CODE("notice_code", "公告编码"),
        ;
        private String val;
        private String desc;

        NoticeCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (NoticeCode type : NoticeCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 拜访步骤编码
     */
    public enum VisitStepCode {
        SFA_STEP_CODE_DEF_PROGRAMME("sfa_step_code_def_programme", "方案活动执行"),
        SFA_STEP_CODE_SUMMARY("sfa_step_code_summary", "拜访总结"),
        SFA_STEP_CODE_ORDER("sfa_step_code_order", "代客下单"),
        SFA_STEP_CODE_COMPETITOR("sfa_step_code_competitor", "竞品采集"),
        SFA_STEP_CODE_STOCK("sfa_step_code_stock", "库存盘点"),
        SFA_STEP_CODE_DISPLAY("sfa_step_code_display", "陈列活动"),
        SFA_STEP_CODE_COST("sfa_step_code_cost", "费用活动"),
        SFA_STEP_CODE_CHECK("sfa_step_code_store_check", "店面检查"),
        SFA_STEP_CODE_TPM("sfa_step_code_tpm", "TPM活动"),
        SFA_STEP_CODE_HELP_SCORE("sfa_step_code_help_score", "协访评价"),

        ;


        private String val;
        private String desc;

        VisitStepCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static final String DICT_CODE = "sfa_step_code";

        /**
         * 步骤监听器-监听全部步骤
         */
        public static final String LISTENER_ALL = "LISTENER_ALL";
        public static Map<String, String> GETMAP = new HashMap<>();
        public static Map<String, String> VALUES_MAP = new HashMap<>();

        public static String getStepCode(String values) {
            String key = null;
            for (VisitStepCode type : VisitStepCode.values()) {
                if (values.contains(type.getDesc())) {
                    key = type.getVal();
                }
            }
            return key;
        }

        static {
            for (VisitStepCode type : VisitStepCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        static {
            for (VisitStepCode type : VisitStepCode.values()) {
                VALUES_MAP.put(type.getDesc(), type.getVal());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 线路组编码
     */
    public enum VisitGroupCode {
        SFA_VISIT_GROUP_CODE("sfa_visit_group", "线路组编码"),
        ;
        private String val;
        private String desc;

        VisitGroupCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (VisitGroupCode type : VisitGroupCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 拜访计划编码
     */
    public enum VisitPLanCode {
        SFA_VISIT_LINE_CODE("sfa_visit_line_code", "线路组拜访计划编码"),
        SFA_VISIT_OUTLETS_CODE("sfa_visit_outlets_code", "网点拜访计划编码"),
        SFA_VISIT_RATE_CODE("sfa_visit_rate_code", "频率拜访计划编码"),
        ;
        private String val;
        private String desc;

        VisitPLanCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (VisitPLanCode type : VisitPLanCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 订单编码
     */
    public enum ORDER_CODE {
        SFA_ORDER_CODE("order_code", "订单编码"),
        ;
        private String val;
        private String desc;

        ORDER_CODE(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (ORDER_CODE type : ORDER_CODE.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 活动编码
     */
    public enum activityCode {
        ACTIVITY_CODE("activity_code", "活动编码"),
        ;
        private String val;
        private String desc;

        activityCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (activityCode type : activityCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 活动方案编码
     */
    public enum schemeCode {
        SCHEME_CODE("scheme_code", "活动方案编码"),
        SCHEME_ACTIVITY_TREATY_CODE("scheme_activity_treaty_code", "活动方案协议编码"),
        SCHEME_ACTIVITY_CODE("scheme_activity_code", "方案活动编码"),
        ;
        private String val;
        private String desc;

        schemeCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (activityCode type : activityCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

}
