package com.biz.crm.eunm.sfa;

import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserUtils;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

/**
 * @Description:sfa 拜访常量
 * @Author: liuhongming
 * @Date: 2020/9/21 18:25
 **/
public class SfaVisitEnum {
    /**
     * 拜访大类
     */
    public enum VisitBigType {
        VISIT("VISIT", "拜访"), //拜访
        HELP_VISIT("HELP_VISIT", "协访"), //协访
        UNFAMILIAR_VISIT("UNFAMILIAR_VISIT", "陌拜"); //陌拜
        private String val;
        private String desc;

        VisitBigType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        /**
         * 拜访监听器,今天全部大类
         */
        public static String LISTENER_ALL = "LISTENER_ALL";
        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (VisitBigType type : VisitBigType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
    /**
     * sfa 客户类型
     */
    public enum ClientType {
        DEALER("dealer", "经销商"),
//        BATCH_DEALER("batchDealer", "二批商"),
        TERMINAL("terminal", "终端"),;
        private String val;
        private String desc;

        ClientType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        /**
         * 系统数据字典
         */
        public static final String DICT_CODE = "sfacusType";
        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (ClientType type : ClientType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }



    /**
     * 拜访类型
     */
    public enum visitType {
        TEMP_VISIT("temporary", "临时拜访"), //临时拜访  计划外
        PLAN_VISIT("plan", "计划拜访"); //计划拜访-计划内
        private String val;
        private String desc;

        visitType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (visitType type : visitType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 拜访大类型
     */
    public enum sfaVisitType {
        VISIT("visit","拜访"),
        ASSIT_TYPE("helpDefense", "协访"),; //协访
        private String val;
        private String desc;

        sfaVisitType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (sfaVisitType type : sfaVisitType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 拜访状态 拜访状态;0:未拜访 1:拜访中 2:拜访完成
     */
    public enum visitStatus {
        V1("0", "未拜访"),
        V2("1", "拜访中"),
        V3("2", "拜访完成"),
        V4("3", "异常"),
        /** 未完成(拜访中未主动提交数据) */
        V5("5", "未完成"),
        V6("6", "已过期"),
        ;
        private String val;
        private String desc;
        /**
         * 系统数据字典
         */
        public static final String DICT_CODE = "visit_status";
        visitStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (visitStatus type : visitStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 协访状态
     */
    public enum HelpVisitStatus {
        READY_HELP_DEFENSE("0", "待协访"),
        IN_HELP_DEFENSE("1", "协访中"),
        ALREADY_SUCCESS("2", "已协访"),
        ALREADY_OVERDUE("3","已过期"),
        EX("4", "异常"),
        /** 未完成(拜访中未主动提交数据) */
        NO_COMMIT("5", "未完成"),
        ;
        private String val;
        private String desc;

        HelpVisitStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (HelpVisitStatus type : HelpVisitStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 陌拜状态
     */
    public enum MoVisitStatus {
        IN_VISIT("1", "陌拜中"),
        ALREADY_SUCCESS("2", "已陌拜"),
        ;
        private String val;
        private String desc;

        MoVisitStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public enum visitButton {
        NAVIGATION("1", "导航"),
        PHONE("2", "电话"),
        EXCEPTION("3", "异常"),
        VISIT("4", "拜访"),
        HELP_VISIT("4", "协访"),
        UNFAMILIAR_VISIT("4", "陌拜"),
        NEW("6", "新增客户"),
        DETAIL("5", "详情"),
        EXCEPTION_DETAIL("7", "异常详情");
        private String val;
        private String desc;

        visitButton(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        /**
         * 拜访按钮
         * @param visitUserName
         * @param visitDate
         * @param visitStatus
         * @return
         */
        public static Map<String, String> buildVisitButton(String visitUserName, String visitDate, String visitStatus){
            LocalDate now = LocalDate.now();
            LocalDate localVisitDate = LocalDate.parse(visitDate, CrmDateUtils.yyyyMMdd);
            String username = UserUtils.getUser().getUsername();
            AssertUtils.isNotEmpty(username, "未获取到登陆人信息");
            Map<String, String> map = new HashMap<>();
            if (visitStatus.equals(SfaVisitEnum.visitStatus.V1.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.EXCEPTION.getVal(), SfaVisitEnum.visitButton.EXCEPTION.getDesc());
                map.put(SfaVisitEnum.visitButton.VISIT.getVal(), SfaVisitEnum.visitButton.VISIT.getDesc());
            } else if (visitStatus.equals(SfaVisitEnum.visitStatus.V2.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.VISIT.getVal(), SfaVisitEnum.visitButton.VISIT.getDesc());
            } else if (visitStatus.equals(SfaVisitEnum.visitStatus.V3.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.DETAIL.getVal(), SfaVisitEnum.visitButton.DETAIL.getDesc());
            } else if (visitStatus.equals(SfaVisitEnum.visitStatus.V4.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getVal(), SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getDesc());
            }else if (visitStatus.equals(SfaVisitEnum.visitStatus.V5.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.DETAIL.getVal(), SfaVisitEnum.visitButton.DETAIL.getDesc());
            }else if (visitStatus.equals(SfaVisitEnum.visitStatus.V6.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
            }

            //拜访人不是当前登陆用户，不展示拜访按钮和异常提报按钮
            if (!visitUserName.equals(username)) {
                map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal());
                map.remove(SfaVisitEnum.visitButton.VISIT.getVal());
            }

            //当前不是拜访日期，不展示拜访按钮和异常提报按钮
            if (now.compareTo(localVisitDate) != 0) {
                map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal());
                map.remove(SfaVisitEnum.visitButton.VISIT.getVal());
            }
            //拜访日期大于当前日期，不展示详情按钮
            if (localVisitDate.compareTo(now) > 0){
                map.remove(SfaVisitEnum.visitButton.DETAIL.getVal());
                map.remove(SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getVal());
            }
            return map;
        }

        /**
         * 协访按钮
         * @param visitUserName
         * @param visitDate
         * @param visitStatus
         * @return
         */
        public static Map<String, String> buildHelpVisitButton(String visitUserName, String visitDate, String visitStatus){
            LocalDate now = LocalDate.now();
            LocalDate localVisitDate = LocalDate.parse(visitDate, CrmDateUtils.yyyyMMdd);
            String username = UserUtils.getUser().getUsername();
            AssertUtils.isNotEmpty(username, "未获取到登陆人信息");
            Map<String, String> map = new HashMap<>();
            if (visitStatus.equals(SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal())) {
                map.put(visitButton.NAVIGATION.getVal(), visitButton.NAVIGATION.getDesc());
                map.put(visitButton.PHONE.getVal(), visitButton.PHONE.getDesc());
                map.put(visitButton.EXCEPTION.getVal(), visitButton.EXCEPTION.getDesc());
                map.put(visitButton.HELP_VISIT.getVal(), visitButton.HELP_VISIT.getDesc());
            } else if (visitStatus.equals(SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.HELP_VISIT.getVal(), SfaVisitEnum.visitButton.HELP_VISIT.getDesc());
            } else if (visitStatus.equals(SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.DETAIL.getVal(), SfaVisitEnum.visitButton.DETAIL.getDesc());
            } else if (visitStatus.equals(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getVal(), SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getDesc());
            }else if (visitStatus.equals(SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.DETAIL.getVal(), SfaVisitEnum.visitButton.DETAIL.getDesc());
            }else if (visitStatus.equals(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
            }else if (visitStatus.equals(SfaVisitEnum.HelpVisitStatus.EX.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getVal(), SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getDesc());
            }

            //拜访人不是当前登陆用户，不展示拜访按钮和异常提报按钮
            if (!visitUserName.equals(username)) {
                map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal());
                map.remove(SfaVisitEnum.visitButton.HELP_VISIT.getVal());
            }

            //当前不是拜访日期，不展示拜访按钮和异常提报按钮
            if (now.compareTo(localVisitDate) != 0) {
                map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal());
                map.remove(SfaVisitEnum.visitButton.HELP_VISIT.getVal());
            }
            //拜访日期大于当前日期，不展示详情按钮
            if (localVisitDate.compareTo(now) > 0){
                map.remove(SfaVisitEnum.visitButton.DETAIL.getVal());
                map.remove(SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getVal());
            }
            return map;
        }

        /**
         * 陌拜按钮
         * @param visitUserName
         * @param visitDate
         * @param visitStatus
         * @return
         */
        public static Map<String, String> buildVisitUnfamiliarButton(String visitUserName, String visitDate, String visitStatus){
            LocalDate now = LocalDate.now();
            LocalDate localVisitDate = LocalDate.parse(visitDate, CrmDateUtils.yyyyMMdd);
            String username = UserUtils.getUser().getUsername();
            AssertUtils.isNotEmpty(username, "未获取到登陆人信息");
            Map<String, String> map = new HashMap<>();
            if (visitStatus.equals(SfaVisitEnum.visitStatus.V1.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(visitButton.UNFAMILIAR_VISIT.getVal(), SfaVisitEnum.visitButton.UNFAMILIAR_VISIT.getDesc());
            } else if (visitStatus.equals(SfaVisitEnum.visitStatus.V2.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.UNFAMILIAR_VISIT.getVal(), SfaVisitEnum.visitButton.UNFAMILIAR_VISIT.getDesc());
            } else if (visitStatus.equals(SfaVisitEnum.visitStatus.V3.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.DETAIL.getVal(), SfaVisitEnum.visitButton.DETAIL.getDesc());
            } else if (visitStatus.equals(SfaVisitEnum.visitStatus.V4.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
            }else if (visitStatus.equals(SfaVisitEnum.visitStatus.V5.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
                map.put(SfaVisitEnum.visitButton.DETAIL.getVal(), SfaVisitEnum.visitButton.DETAIL.getDesc());
            }else if (visitStatus.equals(SfaVisitEnum.visitStatus.V6.getVal())) {
                map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
                map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
            }

            map.put(SfaVisitEnum.visitButton.NEW.getVal(), SfaVisitEnum.visitButton.NEW.getDesc());
            //当前不是拜访日期，不展示陌拜按钮
            if (now.compareTo(localVisitDate) != 0) {
                map.remove(SfaVisitEnum.visitButton.UNFAMILIAR_VISIT.getVal());
            }
            //拜访日期大于当前日期，不展示详情按钮
            if (localVisitDate.compareTo(now) > 0){
                map.remove(SfaVisitEnum.visitButton.DETAIL.getVal());
            }
            return map;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (visitStatus type : visitStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 维度类型（线路组、网点、频率	）
     */
    public enum routeTypeEnum {
        R1(routeTypeEnum.line, "线路组"),
        R2(routeTypeEnum.outlets, "网点"),
        R3(routeTypeEnum.rate, "频率");
        private String val;
        private String desc;
        /** 线路组 */
        public static final String line = "line";
        /** 网点 */
        public static final String outlets = "outlets";
        /** 频率 */
        public static final String rate = "rate";

        routeTypeEnum(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.routeTypeEnum type : SfaVisitEnum.routeTypeEnum.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }


        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 拜访排除周几
     */
    public enum visitWeek {
        MONDAY("1", "星期一"),
        TUESDAY("2", "星期二"),
        WEDNESDAY("3", "星期三"),
        THURSDAY("4", "星期四"),
        FRIDAY("5", "星期五"),
        SATURDAY("6", "星期六"),
        SUNDAY("7", "星期天");
        private String val;
        private String desc;

        visitWeek(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.visitWeek type : SfaVisitEnum.visitWeek.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    public enum visitPicType {
        DEALER_IN_STORE_PIC("1", "进店打卡"),
        DEALER_OUT_STORE_PIC("2", "离店打卡"),
        DEALER_EXCEPTION_PIC("3", "异常报备拍照"),
        CONTEND_COMMODITY_PIC("4", "竞品采集拍照"),
        REGULAR_SHELF_DISPLAY("5", "常规货架陈列"),
        MATERIAL_DISPLAY("6", "物料陈列"),
        PRICE("7", "价格签");

        private String val;
        private String desc;

        visitPicType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.visitPicType type : SfaVisitEnum.visitPicType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }




    public enum checkStoreType {
        REGULAR_SHELF_DISPLAY("0", "常规货架陈列"),
        MATERIAL_DISPLAY("1", "物料陈列"),
        PRICE("2", "价格签"),
        ;
        private String val;
        private String desc;

        checkStoreType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (checkStoreType type : checkStoreType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }



    /**
     * 是否完成
     */
    public enum isSuccess {
        NOT_SUCCESS("0", "未完成"),
        ALREADY_SUCCESS("1", "已完成"),
        ;
        private String val;
        private String desc;

        isSuccess(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (isSuccess type : isSuccess.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
    /**
     * 拜访步骤编码
     */
    public enum SfaStepCode {
        SFA_STEP_CODE_IN_STORE("sfa_step_code_in_store","进店打卡"),
        SFA_STEP_CODE_OUT_STORE("sfa_step_code_out_store","离店打卡"),
        ;
        /** 数据字典 */
        public static final String DICT_CODE = "sfa_step_code";



        private String val;
        private String desc;

        SfaStepCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaStepCode type : SfaStepCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 拜访步骤模板
     */
    public enum visitStep {
        VISIT_STEP_DEF(visitStep.def,"默认步骤模板"),
        VISIT_STEP_IN_STORE(visitStep.inStore,"进店打卡"),
        VISIT_STEP_OUT_STORE(visitStep.outStore,"离店打卡"),
        VISIT_STEP_INOUT(visitStep.inout,"进离店"),
        VISIT_STEP_STOCK(visitStep.stock,"库存盘点"),
        VISIT_STEP_COMPETITOR(visitStep.competitor,"竞品采集"),
        VISIT_STEP_ORDER(visitStep.order,"订单采集"),
        VISIT_STEP_DISPLAY(visitStep.display,"陈列活动"),
        VISIT_STEP_COST(visitStep.cost,"费用活动"),
        VISIT_STEP_TPM(visitStep.tpm,"tpm活动"),
        VISIT_STEP_SUMMARY(visitStep.summary,"拜访总结"),
        VISIT_STEP_STORE_CHECK(visitStep.storeCheck,"店面检查"),
        VISIT_STEP_HELP_SCORE(visitStep.helpScore,"协访评价"),
        ;
        /** 默认步骤模板 */
        public static final String def = "def_step_template";
        /** 进店打卡 */
        public static final String inStore = "inStore";
        /** 离店打卡 */
        public static final String outStore = "outStore";
        /** 进离店 */
        public static final String inout = "inout";
        /** 库存盘点 */
        public static final String stock = "stock";
        /** 竞品采集 */
        public static final String competitor = "competitor";
        /** 订单采集 */
        public static final String order = "order";
        /** 陈列活动 */
        public static final String display = "display";
        /** 费用活动 */
        public static final String cost = "cost";
        /** tpm活动 */
        public static final String tpm = "tpm";
        /** 拜访总结 */
        public static final String summary = "summary";
        /** 店面检查 */
        public static final String storeCheck = "storeCheck";
        /** 协访评价 */
        public static final String helpScore = "helpScore";

        private String val;
        private String desc;

        visitStep(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (visitStep type : visitStep.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }



    /**
     * 是否合格
     */
    public enum SfaVisitQualified {
        QUALIFIED("1","合格"),
        NOT_QUALIFIED("0","不合格"),

        ;
        private String val;
        private String desc;

        SfaVisitQualified(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        public static final String DICT_CODE = "sfa_visit_qualified";
        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitQualified type : SfaVisitQualified.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 客户查询关键字（高德）
     */
    public enum customerKeyword {
        /**
         * 系统数据字典
         */
        CUSTOMER_KEYWORD_ENUM("1","sfa_nearby_customer_keyword");

        private String code;
        private String desc;

        customerKeyword(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }

    /**
     * 指标类型
     */
    public enum indexType {
        /**
         * 系统数据字典
         */
        INDEX_TYPE("1","indexType"),
        XZWD("xzwd", "新增网点"),
        WDBF("wdbf", "网点拜访"),
        XD("xd", "下单次数");

        private String code;
        private String desc;

        indexType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }

    /**
     * 地图数据
     */
    public enum mapData {

        /**
         * 系统数据字典
         */
        MAP_DATA("1","map_data"),
        TENCENT_MAP_DATA("2","tencent_map_data"),
        GAODE_MAP_DATA("3","gaode_map_data"),
        GAODE_MAP_POI_DATA("4","gaode_map_poi_data"),
        ;

        private String code;
        private String desc;

        mapData(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }


    public enum VISIT_OFF_LINE {
        online("online", "在线"),
        //        BATCH_DEALER("batchDealer", "二批商"),
        offline("offline", "离线"),;
        private String val;
        private String desc;

        VISIT_OFF_LINE(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        /**
         * 系统数据字典
         */
        public static final String DICT_CODE = "sfacusType";
        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (VISIT_OFF_LINE type : VISIT_OFF_LINE.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public enum VISIT_CONTROL {
        file("sfa_control_type_attachment", "附件列表"),
        ;
        private String val;
        private String desc;

        VISIT_CONTROL(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        /**
         * 系统数据字典
         */
        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (VISIT_CONTROL type : VISIT_CONTROL.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

}
