package com.biz.crm.util.dms;


import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Locale;
import jodd.time.TimeUtil;
import lombok.SneakyThrows;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.commons.lang3.time.DateUtils;
import org.elasticsearch.common.rounding.DateTimeUnit;

public class PromotionPolicyUtil {

    /**
     * 计算政策状态
     * @param enableStatus
     * @param beginTime
     * @param endTime
     * @return
     */
    public static final String promotionPolicyStatus(String enableStatus
            , String beginTime, String endTime){

        if(CrmEnableStatusEnum.DISABLE.getCode().equals(enableStatus)){
            return enableStatus;
        }
        return timeActive(beginTime, endTime);
//        Map<String, String> map = DictUtil.getDictValueMapsByCodes(PromotionPolicyEunm.dict_type_as_promotion_policy_status);
//        if(null == map){
//            return;
//        }
//        this.promotionPolicyStatusName = map.get(this.promotionPolicyStatus);
    }

    /**
     * 计算政策状态(去掉enable)
     * @param beginTime
     * @param endTime
     * @return
     */
    public static final String promotionPolicyStatusNoEnable(String beginTime, String endTime){
        return timeActive(beginTime, endTime);
//        Map<String, String> map = DictUtil.getDictValueMapsByCodes(PromotionPolicyEunm.dict_type_as_promotion_policy_status);
//        if(null == map){
//            return;
//        }
//        this.promotionPolicyStatusName = map.get(this.promotionPolicyStatus);
    }

    /**
     * 计算该政策是否在有效期内
     * 3个业务状态， 待执行：null，执行中：true，已结束：false
     * waiting，执行中：running，已结束：finished
     *  @author: luoqi
     *  @Date: 2020-10-19 15:40
     *  @version: V1.0
     *  @Description:
     */
    @SneakyThrows
    public static final String timeActive(String beginTime, String endTime){
        if(StringUtils.isBlank(beginTime) || StringUtils.isBlank(endTime)){
            return PromotionPolicyEunm.PromotionPolicyStatusEunm.WAITING.getCode();
        }
        long tempBegin = DateUtils.parseDate(beginTime, Locale.CHINESE, "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss").getTime();
        long tempEnd = DateUtils.parseDate(endTime, Locale.CHINESE, "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss").getTime();
        long now = System.currentTimeMillis();
        if(tempBegin > now){
            return PromotionPolicyEunm.PromotionPolicyStatusEunm.WAITING.getCode();
        }
        if( now > tempBegin && now < tempEnd){
            return PromotionPolicyEunm.PromotionPolicyStatusEunm.RUNNING.getCode();
        }else{
            return PromotionPolicyEunm.PromotionPolicyStatusEunm.FINISHED.getCode();
        }
    }
}
