package com.biz.crm.util.es.permission;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentUserPermissionRespVo;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PermissionUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;


/**
 * ES数据权限切面拦截
 *  @author: luoqi
 *  @Date: 2021-5-7 11:29
 *  @version: V1.0
 *  @Description:
 */
@Aspect
@Component
@Slf4j
public class EsDataPermissionSupportAspect {
    private static final String DEF_VAL = "-10000";

    @Before("execution(* org.springframework.data.elasticsearch.core.ElasticsearchOperations.*Page(..))")
    public void doBefore(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        if(null == args || args.length == 0){
            return;
        }
        Object query = args[0];
        if(null == query){
            return;
        }
        EsDataPermissionResolver permission = (EsDataPermissionResolver) ThreadLocalUtil.getObj(EsDataPermissionAspect.ES_DATA_PERMISSION_KEY);
        if(null == permission){
            if(log.isInfoEnabled()){
                log.info("ES数据权限切面拦截：未获取到当前线程权限注解副本！");
            }
            return;
        }
        MdmCurrentPermissionRespVo permissionRespVo = this.loadPermissionConfig();
        if(null == permissionRespVo){
            return;
        }
        if(query instanceof SearchQuery){
            EsDataPermissionContext<SearchQuery> context = new EsDataPermissionContext();
            context.setPermission(permission);
            context.setFilterPermissionObjCodeList(permissionRespVo.getFilterPermissionObjCodeList());
            context.setUserPermissionList(permissionRespVo.getUserPermissionList());
            context.setQuery((SearchQuery)query);
            this.forSearchQuery(context);
        }
    }

    protected MdmCurrentPermissionRespVo loadPermissionConfig(){
        MdmCurrentPermissionRespVo permissionRespVo = PermissionUtil.currentUserPermissionList();
        if(null == permissionRespVo){
            if(log.isInfoEnabled()){
                log.info("ES数据权限切面拦截：未获取到当前用户权限配置数据！");
            }
            return null;
        }

        List<String> filterPermissionObjCodeList = permissionRespVo.getFilterPermissionObjCodeList();
//        filterPermissionObjCodeList = Lists.newArrayList("posCode");
        if(CollectionUtils.isEmpty(filterPermissionObjCodeList)){
            if(log.isInfoEnabled()){
                log.info("ES数据权限切面拦截：未获取到当前接口权限对象配置数据！");
            }
            return null;
        }
        List<MdmCurrentUserPermissionRespVo> userPermissionList = permissionRespVo.getUserPermissionList();
//        userPermissionList = Lists.newArrayList(new MdmCurrentUserPermissionRespVo(){{setPermissionObjCode("posCode");setPermissionValueList(Lists.newArrayList("555"));}});
        if(null == userPermissionList){
            if(log.isInfoEnabled()){
                log.info("ES数据权限切面拦截：未获取到当前接口权限值数据！");
            }
            permissionRespVo.setUserPermissionList(Lists.newArrayList());
        }

        return permissionRespVo;
    }

    protected void forSearchQuery(EsDataPermissionContext<SearchQuery> context){
        if(log.isInfoEnabled()){
            log.info("ES数据权限切面拦截：context = {}", JsonPropertyUtil.toJsonString(context));
        }
        SearchQuery query = context.getQuery();
        EsDataPermissionResolver permission = context.getPermission();
        List<String> filterPermissionObjCodeList = context.getFilterPermissionObjCodeList();
        List<MdmCurrentUserPermissionRespVo> userPermissionList = context.getUserPermissionList();
        Map<String, List<MdmCurrentUserPermissionRespVo>> groupByObjCode = userPermissionList.stream().collect(Collectors.groupingBy(MdmCurrentUserPermissionRespVo :: getPermissionObjCode));
        BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)query.getQuery();
        for (String objCode : filterPermissionObjCodeList) {
            if(groupByObjCode.containsKey(objCode)){
                List<String> permissionValues = this.permissionValues(groupByObjCode.get(objCode));
                String dataFieldName = permission.get(objCode);
                if(StringUtils.isBlank(dataFieldName)){
                    continue;
                }
                boolQueryBuilder.must(QueryBuilders.termsQuery(dataFieldName, permissionValues));
            }

        }
    }

    protected List<String> permissionValues(List<MdmCurrentUserPermissionRespVo> permissionRespVos){
        if(null == permissionRespVos){
            permissionRespVos = Lists.newArrayList();
        }
        List<String> permissionValues = Lists.newArrayList();
        for (MdmCurrentUserPermissionRespVo permissionRespVo : permissionRespVos) {
            if(null == permissionRespVo.getPermissionValueList()){
                continue;
            }
            permissionValues.addAll(permissionRespVo.getPermissionValueList());
        }
//        if(permissionValues.size() == 0){
            //该权限对象没有权限值，设置一个占位值来达到数据帅选的目的
            permissionValues.add(DEF_VAL);
//        }
        return permissionValues;
    }

//    @AfterReturning(returning = "ret", pointcut = "@annotation(EsDataPermission)")
//    public void doAfterReturning(Object ret)  {
//        ThreadLocalUtil.delObj();
//    }
//
//    @AfterThrowing(value = "@annotation(EsDataPermission)", throwing = "throwable")
//    public void doAfterThrowing(Throwable throwable) {
//        ThreadLocalUtil.delObj();
//    }
}
