package com.biz.crm.util.websocket;

import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.util.websocket.feign.WebsocketFeign;
import com.biz.crm.util.websocket.vo.WebsocketMsg;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.util.websocket
 * @Description: websocket 发送消息工具类
 * @date 2021/3/31 下午2:24
 */
@Component
@Slf4j
public class WebsocketUtil {
    @Autowired
    private WebsocketFeign websocketFeign;

    private void initFeign(){
        if(websocketFeign==null){
            websocketFeign = SpringApplicationContextUtil.getApplicationContext().getBean(WebsocketFeign.class);
        }
    }

    /**
     * 发送websockt消息
     */
    public void sendMsg(WebsocketMsg websocketMsg){
      try {
          websocketFeign.sendMsg(websocketMsg);
      }catch (Exception e){
       log.error("发送websock失败",e);
      }
    }

    public void sendMsg(String sid,String msg){
        WebsocketMsg websocketMsg = new WebsocketMsg();
        websocketMsg.setSid(sid);
        websocketMsg.setMsg(msg);
        try {
            websocketFeign.sendMsg(websocketMsg);
        }catch (Exception e){
            log.error("发送websock失败",e);
        }
    }

}
