package com.biz.crm.util.websocket.feign;

import com.biz.crm.util.Result;
import com.biz.crm.util.websocket.feign.impl.WebsocketFeignImpl;
import com.biz.crm.util.websocket.vo.WebsocketMsg;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.util.websocket.feign
 * @Description: TODO
 * @date 2021/3/31 下午3:41
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "websocketFeign", name = "crm-excel", path = "excel", fallbackFactory = WebsocketFeignImpl.class)
public interface WebsocketFeign {

    /**
     * 发送公用websock参数
     *
     * @param websocketMsg
     * @return
     */
    @PostMapping("/common/websocket/sendMsg")
    Result sendMsg(@RequestBody WebsocketMsg websocketMsg);
}
