package com.biz.crm.base.controller;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.config.ExceptionMsg;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.UUID;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.base.controller
 * @Description: TODO
 * @date 2020/8/31 上午11:16
 */
@RestController
@RequestMapping("/registryController")
@Api(value = "获取登录信息", tags = "获取登录信息")
public class RegistryController {
    @Autowired
    private RedisService redisService;
    @ApiOperation(value = "DEBUG 用户注册调试", notes = "开发调试使用正式会关闭改方法")
    @GetMapping(value = "RegistryDebug")
    public Result<String> RegistryDebug(@RequestParam("username") String username) {
        //TODO 临时返回一个认证 后面完善
        Result<String> result = new Result<>();
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(username);
        String token = UUID.randomUUID().toString().replaceAll("-","");
        result.setResult(token);
        redisService.setDays(token,userRedis, RedisParam.TIME1);
        return result;
    }

    @ApiOperation(value = "DEBUG 查询异常详情", notes = "DEBUG 查询异常详情")
    @GetMapping(value = "getExceptionMsg")
    public Result<ExceptionMsg> getExceptionMsg(@RequestParam String code){
        Result<ExceptionMsg> result = new Result<>();
        Object o =  redisService.get(code);
        if(o!=null){
            result.setResult((ExceptionMsg)o);
        }else {
            ExceptionMsg exceptionMsg = new ExceptionMsg();
            exceptionMsg.setMsg(code+":没有查询到异常信息");
            result.setResult(exceptionMsg);
        }
        return result;
    }
}
