package com.biz.crm.util;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.service.RedisService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.RedisTemplate;

import javax.servlet.http.HttpServletRequest;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.util
 * @Description: 登录信息
 * @date 2020/8/26 下午3:04
 */
@Slf4j
public class UserUtils {
    private static UserAutoConfig userAutoConfig = null;
    private static RedisService redisService;
    private static void initRedis(){
        if(redisService==null){
            redisService = SpringApplicationContextUtil.getApplicationContext().getBean(RedisService.class);
        }
    }
    //得到当前登录人
    public static UserRedis getUser() {
        UserRedis userRedis = ThreadLocalUtil.getUser();
        if(userRedis!=null){
            return userRedis;
        }
        try {
            String token = getToken();
            if(StringUtils.isEmpty(token)){
                return null;
            }else {
                initRedis();
                Object o  = redisService.get(token);
                if(o==null){
                    redisService.setSeconds(token,null, RedisParam.TIME10);
                }else {
                    userRedis = (UserRedis)o;
                    setUserLocal(userRedis);
                }
            }
        }catch (Exception e){
            log.error("获取当前用户:",e);
        }
        return userRedis;
    }

    //设置当前用户在本地
    private static void setUserLocal( UserRedis userRedis) {
        if(userRedis==null){
            return;
        }
        ThreadLocalUtil.setUser(userRedis);
    }

    /**
     * 获取当前token
     * @return
     */
    public static String getToken(){
        HttpServletRequest request =  HttpServletRequestUtil.getRequest();
        if(request==null){
            Object tokenLock = ThreadLocalUtil.getObj(GlobalParam.TOKEN);
            String loginUserToken = tokenLock==null?"":tokenLock.toString();
            return loginUserToken;
        }
        String token = request.getHeader(GlobalParam.TOKEN);
        return token;
    }

    public static String getToken(String key) {
        initRedis();
        return redisService.getAndSet(key);
    }
    /**
     * 默认设置当前登录权限，如果没有登录情况
     */
    public static void  doTokenForNull(){
        initConfig();
        if(StringUtils.isEmpty(userAutoConfig.getUsername())){
            return;
        }
        try {
            ConcurrentHashMap<String,Object> map = new ConcurrentHashMap<>();
            String token = UUID.randomUUID().toString().replaceAll("-","");
            map.put(GlobalParam.TOKEN, token);
            UserRedis userRedis = new UserRedis();
            userRedis.setUsername(userAutoConfig.getUsername());
            ThreadLocalUtil.stObj(map);
//            userRedis.setId("admin");
            redisService.setHours(token, userRedis, RedisParam.TIME1);
        }catch (Exception e){
            log.error("默认设置权限错误",e);
        }
    }
    private static void initConfig(){
        if(userAutoConfig==null){
            userAutoConfig = SpringApplicationContextUtil.getApplicationContext().getBean(UserAutoConfig.class);
        }
    }

    public static void setUser(String token,UserRedis userRedis) {
        initRedis();
        redisService.set(token, userRedis);
    }
}
