package com.biz.crm.feign;

import com.biz.crm.nebular.mdm.humanarea.EngineUserReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 一个拥有权限信息的业务系统用户定义feign接口
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "mdmEngineUserFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmEngineUserFeign.MdmEngineUserFeignImpl.class)
public interface MdmEngineUserFeign {


    @ApiOperation("查询用户基本信息")
    @PostMapping("/engineuser/user_detail")
    Result<EngineUserRespVo> findUserDetail(@RequestBody EngineUserReqVo userReqVo);

    @Slf4j
    @Component
     class MdmEngineUserFeignImpl implements FallbackFactory<MdmEngineUserFeign> {

        @Override
        public MdmEngineUserFeign create(Throwable throwable) {
            return new MdmEngineUserFeign() {

                @Override
                public Result<EngineUserRespVo> findUserDetail(EngineUserReqVo userReqVo) {
                    log.error("远程查询用户基本信息失败");
                    return null;
                }
            };
        }
    }
}
