package com.biz.crm.config;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: TODO
 * @date 2020/9/1 下午5:32
 */
@ControllerAdvice
@Slf4j
public class GlobalExceptionHandler {
    @Value("${spring.application.name:}")
    private String applicationName;
    private static RedisService redisService;


    /**
     * 应用到所有@RequestMapping注解方法，在其执行之前初始化数据绑定器
     *
     * @param binder
     */
    @InitBinder
    public void initBinder(WebDataBinder binder) {

    }

    /**
     * 全局异常捕捉处理
     *
     * @return
     */
    @ExceptionHandler(value = Exception.class)
    @ResponseBody
    public Result errorHandler(Exception e, HttpServletRequest request, HttpServletResponse response) {
        UserRedis userRedis = UserUtils.getUser();
        if(userRedis!=null){
            log.error("进入全局异常当前登录人信息 ： "+JSON.toJSONString(userRedis));
        }
        log.error("进入全局异常", e);
        ExceptionMsg exceptionMsg =  getExceptionToString(e,request.getRequestURL());
        return Result.error("操作失败,错误编码"+exceptionMsg.getCode());
    }


    /**
     * 全局异常捕捉处理
     *
     * @return
     */
    @ExceptionHandler(value = {BusinessException.class})
    @ResponseBody
    public Result errorHandler(BusinessException e, HttpServletRequest request, HttpServletResponse response) {
        UserRedis userRedis = UserUtils.getUser();
        if(userRedis!=null){
            log.error("进入全局异常当前登录人信息 ： "+JSON.toJSONString(userRedis));
        }
        log.error("进入全局业务异常处理", e);
        return Result.error(e.getMsg());
    }

    @ExceptionHandler(value = {IllegalArgumentException.class})
    @ResponseBody
    public Result assertHandler(IllegalArgumentException e, HttpServletRequest request, HttpServletResponse response) {
        String message = e.getMessage();
        log.error("msg:{}",message);
        return Result.error(message);
    }

    private static ExceptionMsg getExceptionToString(Throwable e,StringBuffer url) {
        url = url==null?new StringBuffer():url;
        ExceptionMsg vo = new ExceptionMsg();
        if(redisService==null){
            redisService = SpringApplicationContextUtil.getApplicationContext().getBean(RedisService.class);
        }
        long numCode= redisService.incr(RedisParam.ERROE_CODE,1);
        if (numCode==999999){
            redisService.set(RedisParam.ERROE_CODE,1);
            numCode=1;
        }
        String errorCode = "E"+String.valueOf(numCode);
        vo.setCode(errorCode);
        if (e == null){
            return vo;
        }
        String msg = "请求url:"+url+ "\n\tat";
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        msg += stringWriter.toString();
        vo.setMsg(msg);
        redisService.setDays(errorCode,vo, RedisParam.TIME3);
        return vo;
    }

}
