package com.biz.crm.dict.feign;

import com.biz.crm.dict.entity.DictCategoryVo;
import com.biz.crm.dict.entity.DictVo;
import com.biz.crm.dict.entity.NebulaResult;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataSearchReqVo;
import com.biz.crm.nebular.mdm.dict.dictdata.resp.MdmDictDataRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Collections;
import java.util.List;

/**
 * @author zxw
 **/
@FeignClient(url ="${feign.urlip:}",qualifier ="knlDictFeign" ,name="NEBULA",fallbackFactory = KnlDictFeign.FallBackClass.class)
public interface KnlDictFeign {


//    /**
//     * 获取 字典缓存 并 异步加入redis
//     */
//    @PostMapping(value = "/kernel-api/knlApiDictController/getDictByParamList")
//    AjaxJson<KnlDictDataEntity> getDictByParamList(@RequestParam("dictTypeCode") String dictTypeCode);
//
//    @PostMapping(value = "/kernel-api/knlApiDictController/getDictByParamObj")
//    AjaxJson<KnlDictDataEntity> getDictByParamObj(@RequestParam("dictTypeCode") String dictTypeCode,
//                                                  @RequestParam("dictCode") String dictCode);
//
//    @PostMapping(value = "/kernel-api/knlApiDictController/getDictAttribute")
//    AjaxJson<KnlDictAttributeConfEntity> getDictAttribute(@RequestParam("dictTypeCode") String dictTypeCode);
//
//    /**
//     * 根据父级别id查询字典列表
//     */
//    @PostMapping(value = "/kernel-api/knlApiDictController/getDictListByParentId")
//    AjaxJson<KnlDictDataEntity> getDictListByParentId(@RequestParam("parentId") String parentId);

    /**
     * 查询所有字典分类及数据
     * @return result
     */
    @GetMapping("/v1/nebula/dictCategories/findAll")
    NebulaResult<List<DictCategoryVo>> findAllDict();

    /**
     * 根据分类编码查询分类
     * @param typeCode 分类编码
     * @return 字典分类
     */
    @GetMapping("/v1/nebula/dictCategories/findByCode")
    NebulaResult<DictCategoryVo> findDictTypeByCode(@RequestParam("code") String typeCode);

    /**
     * 根据字典编码查询指定字典
     * @param dictCode 字典编码
     * @return result
     */
    @GetMapping("/v1/nebula/dicts/findDetailsByDictCode")
    NebulaResult<DictVo> findDictByDictCode(@RequestParam("dictCode") String dictCode);

    /**
     * 条件查询字典
     * @param mdmDictDataSearchReqVo 条件
     * @return result
     */
    @PostMapping("/mdm/dict_data/list")
    Result<List<MdmDictDataRespVo>> condition(@RequestBody MdmDictDataSearchReqVo mdmDictDataSearchReqVo);

    @Component
    @Slf4j
    class FallBackClass implements FallbackFactory<KnlDictFeign> {
        @Override
        public KnlDictFeign create(Throwable throwable) {
            return new KnlDictFeign() {

                @Override
                public NebulaResult<List<DictCategoryVo>> findAllDict() {
                    log.error("查询所有字典分类及数据失败");
                    return NebulaResult.fail("查询所有字典分类及数据失败");
                }

                @Override
                public NebulaResult<DictCategoryVo> findDictTypeByCode(String typeCode) {
                    log.error("根据分类编码查询分类失败,分类编码:{}",typeCode);
                    return NebulaResult.fail("根据分类编码查询分类失败");
                }

                @Override
                public NebulaResult<DictVo> findDictByDictCode(String dictCode) {
                    log.error("根据字典编码查询指定字典失败");
                    return NebulaResult.fail("根据字典编码查询指定字典失败");
                }

                @Override
                public Result<List<MdmDictDataRespVo>> condition(MdmDictDataSearchReqVo mdmDictDataSearchReqVo) {
                    log.error("根据条件查询字典失败");
                    return Result.ok(Collections.emptyList());
                }
            };
        }
    }
}
