package com.biz.crm.eunm.tpm;

import org.apache.commons.lang3.StringUtils;

/**
 * @Description:crm 费用预算类型枚举
 * @Author: huanglong
 * @Date: 2020/8/20 18:25
 **/
public enum FeeBudgetTypeEnum {
    DEPARTMENT("department","部门预算"),
    CUSTOMER("customer","客户预算"),
    CHANNEL("channel","渠道预算"),
    TERMINAL("terminal","门店预算"),
    FIXED("fixed","固定预算"),

;

    private String code;
    private String des;

    FeeBudgetTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }
    public static String getStatusName(String code){
        FeeBudgetTypeEnum[] values = FeeBudgetTypeEnum.values();
        String desc=null;
        for (FeeBudgetTypeEnum o : values){
            if(StringUtils.equals(o.getCode(),code)){
                desc=o.getDes();
                break;
            }
        }
        return desc;
    }
    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }
}
