package com.biz.crm.config;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: TODO
 * @date 2020/9/22 下午5:45
 */
@Component
@Slf4j
public class JwtAuthorizationTokenFilter extends OncePerRequestFilter {
    @Autowired
    private RedisService redisService;
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String token = request.getHeader(GlobalParam.TOKEN);
        if(StringUtils.isEmpty(token)){
            //请求头中token为空，则从cookie获取
            Cookie cookie =  CookiesUtil.getCookieByName(request,GlobalParam.TOKEN);
            if(cookie!=null){
                token = cookie.getValue();
            }
        }
        Object o = redisService.get(token);
        if(o!=null){
            //如果token有值，转换为authentication 跳过牛逼哒默认session认证
            UserRedis userRedis = (UserRedis)o;
            if(StringUtils.isNotEmpty(userRedis.getUsername())&&SecurityContextHolder.getContext().getAuthentication() == null){
                UserDetails userDetails = new SecurityUserDetails(userRedis.getUsername(),new ArrayList<>());
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(userDetails, null, userDetails.getAuthorities());
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
        }else {
            /**
            //如果token为空 则取 当前登录人信息
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication!=null&&!(authentication instanceof AnonymousAuthenticationToken)) {
                log.info("无token场景转化 这种请求一般是从牛逼啦来的");
                //这里处理 session转化，如果没有token 则判断当前登录人是否存在
                //如果存在 则产生token  设置到cookie 中， 将用户信息设置到redis中,将token设置到本地线程中
                String username = authentication.getName();
                if(StringUtils.isNotEmpty(username)){
                    token = UUID.randomUUID().toString().replaceAll("-","");
                    UserUtils.setUser(token,username);
//                    redisService.setDays(token,userRedis, RedisParam.TIME1);
                    //设置到请求体cookie中
                    CookiesUtil.doCoke(request,response,token,GlobalParam.TOKEN);
                    //设置本地线程
                    ConcurrentHashMap<String,Object> map = new ConcurrentHashMap<>();
                    map.put(GlobalParam.TOKEN, token);
                    ThreadLocalUtil.stObj(map);
                }
            }
            */
        }

        filterChain.doFilter(request,response);
    }

    /**
     * TODO 临时创建一个用户将程序调通 需要处理
     * @return
     */
    private UserRedis createUserTemp(String username){
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(username);
        return userRedis;
    }
}
