package com.biz.crm.dict.entity;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 数据字典模块数据的导出导入
 *
 * @author zxw
 */
@ApiModel("迁入文件保存实体")
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@Data
public class DictImportVo {

    private String id;

    /**
     * 文件在本地存储路径
     */
    @ApiModelProperty(name = "relativeLocal", value = "文件在本地存储路径", required = true)
    private String relativeLocal;

    /**
     * 重命名后的文件名字
     */
    @ApiModelProperty(name = "fileName", value = "重命名后的文件名字", required = true)
    private String fileName;

    /**
     * 上传文件原名
     */
    @ApiModelProperty(name = "originalFileName", value = "上传文件原名")
    private String originalFileName;

    /**
     * 上传人
     */
    @ApiModelProperty(name = "creator", value = "上传人", required = true)
    private String creator;


    /**
     * 上传时间
     */
    @ApiModelProperty(name = "createTime", value = "上传时间", required = true)
    private Date createTime;

    /**
     * 本次任务是否最终执行,true:已执行，false：未执行
     */
    @ApiModelProperty(name = "executed", value = "本次任务是否最终执行,true:已执行，false：未执行", required = true)
    private Boolean executed;

    /**
     * 任务执行人
     */
    @ApiModelProperty(name = "executor", value = "任务执行人")
    private String executor;


    /**
     * 执行时间
     */
    @ApiModelProperty(name = "executeTime", value = "执行时间")
    private Date executeTime;

    /**
     * 执行结果，1：成功，0：失败
     */
    @ApiModelProperty("执行结果，1：成功，0：失败")
    private Integer executeResult;

    /**
     * 导入明细
     */
    @ApiModelProperty("导入明细")
    private DictImportDetailVo detail;

}
