package com.biz.crm.dict.entity;

import com.biz.crm.util.StringUtils;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author zxw
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class NebulaResult<T> {

    /**
     * 实体
     */
    private T data;

    /**
     * 错误信息
     */
    private String errorMsg;

    /**
     * 信息
     */
    private String message;

    /**
     * 响应编码
     */
    private Integer responseCode;

    /**
     * 是否成功
     */
    private Boolean success;

    /**
     * 时间戳
     */
    private Long timestamp;

    public static <T> NebulaResult<T> fail(String errorMsg) {
        return new NebulaResult<T>().setData(null).setSuccess(false).setErrorMsg(StringUtils.isEmpty(errorMsg)?"操作失败":errorMsg);
    }


//    public static void main(String[] args) {
//        RestTemplate restTemplate = new RestTemplate();
//        String url = "http://localhost:5700/v1/nebula/dictCategories/findAll";
//        HttpHeaders headers = new HttpHeaders();
//        headers.setContentType(MediaType.APPLICATION_JSON);
//        HttpEntity<String> httpEntity = new HttpEntity<>(headers);
//        ResponseEntity<NebulaResult> exchange = restTemplate.exchange(url, HttpMethod.GET, httpEntity, NebulaResult.class);
//        System.out.println(exchange);
//
//    }
}
