package com.biz.crm.dict.feign;

import com.biz.crm.nebular.mdm.dict.resp.MdmDictGroupVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(url = "${feign.urlip:}", qualifier = "mdmDictFeign", value = "crm-mdm", path = "mdm", fallbackFactory = MdmDictFeign.FallBackClass.class)
public interface MdmDictFeign {

    @GetMapping("/mdmdict/getMdmDict")
    Result<MdmDictGroupVo> getMdmDict(@RequestParam("dictTypeCode") String dictTypeCode);

    @GetMapping("/mdmdict/getMdmDictList")
    Result<List<MdmDictGroupVo>> getMdmDictList(@RequestBody List<String> dictTypeCodeList);

    @Component
    @Slf4j
    class FallBackClass implements FallbackFactory<MdmDictFeign> {
        @Override
        public MdmDictFeign create(Throwable throwable) {
            return new MdmDictFeign() {

                @Override
                public Result<MdmDictGroupVo> getMdmDict(String dictTypeCode) {
                    Result<MdmDictGroupVo> result = new Result<>();
                    result.error500("请求失败");
                    return result;
                }

                @Override
                public Result<List<MdmDictGroupVo>> getMdmDictList(List<String> dictTypeCodeList) {
                    Result<List<MdmDictGroupVo>> result = new Result<>();
                    result.error500("请求失败");
                    return result;
                }

            };
        }
    }

}
