package com.biz.crm.eunm.sfa;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:sfa     拜访常量
 * @Author: liuhongming
 * @Date: 2020/9/21 18:25
 **/
public class SfaVisitEnum {

    /**
     * 拜访类型
     */
    public enum VisitType {
        temp_visit("temporary","临时拜访"), //临时拜访  计划外
        plan_visit("plan","计划拜访"), //计划拜访-计划内
        assit_type("helpDefense","协访"); //协访
        private String val;
        private String desc;

        VisitType(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String,String> GETMAP = new HashMap<>();
        static {
            for (SfaVisitEnum.VisitType type : SfaVisitEnum.VisitType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 拜访状态 拜访状态;0:未拜访 1:拜访中 2:拜访完成
     */
    public enum VisitStatus {
        V1("0","未拜访"),
        V2("1","拜访中"),
        V3("2","拜访完成"),
        V4("3","异常"),
        ;
        private String val;
        private String desc;

        VisitStatus(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String,String> GETMAP = new HashMap<>();
        static {
            for (SfaVisitEnum.VisitStatus type : SfaVisitEnum.VisitStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    public enum VisitButton {
        navigation("1","导航"),
        phone("2","电话"),
        exception("3","异常"),
        visit("4","拜访"),
        detail("5","详情")
        ;
        private String val;
        private String desc;

        VisitButton(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String,String> GETMAP = new HashMap<>();
        static {
            for (SfaVisitEnum.VisitStatus type : SfaVisitEnum.VisitStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 维度类型（线路组、网点、频率	）
     */
    public enum routeTypeEnum{
        R1("line","线路组"),
        R2("outlets","网点"),
        R3("rate","频率");
        private String val;
        private String desc;

        routeTypeEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String,String> GETMAP = new HashMap<>();
        static {
            for (SfaVisitEnum.routeTypeEnum type : SfaVisitEnum.routeTypeEnum.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }


        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 拜访排除周几
     */
    public enum visitWeek {
        monday("1","星期一"),
        tuesday("2","星期二"),
        wednesday("3","星期三"),
        thursday("4","星期四"),
        friday("5","星期五"),
        saturday("6","星期六"),
        sunday("7","星期天")
        ;
        private String val;
        private String desc;

        visitWeek(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String,String> GETMAP = new HashMap<>();
        static {
            for (SfaVisitEnum.visitWeek type : SfaVisitEnum.visitWeek.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    public enum visitPicType {
        dealer_in_store_pic("1","进店打卡"),
        dealer_out_store_pic("2","离店打卡"),
        dealer_exception_pic("3","异常报备拍照"),
        ;
        private String val;
        private String desc;

        visitPicType(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String,String> GETMAP = new HashMap<>();
        static {
            for (SfaVisitEnum.visitPicType type : SfaVisitEnum.visitPicType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }





}
